/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.ui.util.PaneState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorState {
    private List<PaneState> rootEntries = new ArrayList<PaneState>(1);
    private List<IStateChangeListener> listeners = new ArrayList<IStateChangeListener>();

    public void addChangeStateListener(IStateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeStateListener(IStateChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(PaneState state) {
        for (IStateChangeListener listener : this.listeners) {
            listener.onStateChanged(state);
        }
    }

    public List<PaneState> getElements() {
        return this.rootEntries;
    }

    public void removeEntry(PaneState paneState) {
        PaneState parent = paneState.getParentPaneState();
        if (parent == null) {
            this.rootEntries.remove(paneState);
        } else {
            parent.removeChild(paneState);
        }
        this.notifyListeners(parent);
    }

    public void paneAdded(PaneState state) {
        if (state == null) {
            return;
        }
        state.setActive(true);
        if (state.getParentPaneState() == null && !this.rootEntries.contains(state)) {
            this.rootEntries.add(state);
            this.notifyListeners(null);
        } else if (state.getParentPaneState() != null && !state.getParentPaneState().getChildren().contains(state)) {
            state.getParentPaneState().addChild(state);
            this.notifyListeners(state.getParentPaneState());
        } else {
            this.notifyListeners(state);
        }
    }

    public void paneRemoved(PaneState state) {
        if (state == null) {
            return;
        }
        state.setActive(false);
        this.notifyListeners(state);
        if (state.getType() == PaneState.PaneType.COMPOSITE_PARENT) {
            for (PaneState child : state.getChildren()) {
                if (!child.isActive()) continue;
                this.paneRemoved(child);
            }
        }
    }

    public static interface IStateChangeListener {
        public void onStateChanged(PaneState var1);
    }
}

