/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleTopic
implements ITopic {
    private String bookName;
    private Node node;
    private XPath xpath;
    private List<ITopic> subTopics;

    public SimpleTopic(String bookName, Node node) {
        this.bookName = bookName;
        this.node = node;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.subTopics = new ArrayList<ITopic>();
        this.initSubtopics();
    }

    private void initSubtopics() {
        NodeList nodes = this.xpathEvalNodes("sub", this.node);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node innerNode = nodes.item(i);
                this.subTopics.add(new SimpleTopic(this.bookName, innerNode));
                ++i;
            }
        }
    }

    private NodeList xpathEvalNodes(String path, Node docroot) {
        NodeList result = null;
        try {
            result = (NodeList)this.xpath.evaluate(path, docroot, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getSubtopics();
    }

    public String getHref() {
        String link = "";
        try {
            link = this.xpath.evaluate("@link", this.node);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return "/org.eclipse.linuxtools.cdt.libhover.devhelp/" + this.bookName + "/" + link;
    }

    public String getLabel() {
        try {
            return this.xpath.evaluate("@name", this.node);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return "";
        }
    }

    public ITopic[] getSubtopics() {
        return this.subTopics.toArray(new ITopic[this.subTopics.size()]);
    }
}

