/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.utils.TreeViewerIterator;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGoToTestResultErrorHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) {
        LinkedList<IWorkbenchPart> listOfPossibleParts = new LinkedList<IWorkbenchPart>();
        listOfPossibleParts.add(HandlerUtil.getActivePart((ExecutionEvent)event));
        listOfPossibleParts.add((IWorkbenchPart)HandlerUtil.getActiveEditor((ExecutionEvent)event));
        TreeViewer viewer = this.handleActiveWorkbenchParts(listOfPossibleParts);
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        TestResultNode startingNode = null;
        if (selection.getFirstElement() instanceof TestResultNode) {
            startingNode = (TestResultNode)selection.getFirstElement();
        } else {
            Object[] rootElements;
            Object[] objectArray = rootElements = contentProvider.getElements(viewer.getInput());
            int n = rootElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof TestResultNode) {
                    startingNode = (TestResultNode)element;
                    break;
                }
                ++n2;
            }
        }
        TestResultNode targetNode = null;
        TreeViewerIterator iter = new TreeViewerIterator(viewer, startingNode, this.isForwardIteration());
        while (iter.hasNext() && targetNode == null) {
            TestResultNode node;
            Object nextElement = iter.next();
            if (!(nextElement instanceof TestResultNode) || !this.isErrorNode(node = (TestResultNode)nextElement)) continue;
            targetNode = node;
        }
        if (targetNode != null) {
            viewer.reveal(targetNode);
            viewer.setSelection((ISelection)new StructuredSelection(targetNode));
        }
        return null;
    }

    private final boolean isErrorNode(TestResultNode node) {
        int status = node.getStatus();
        List resultNodeList = node.getResultNodeList();
        if (resultNodeList != null) {
            return status == 2 || status == 9 || status == 11 || status == 6 && node.getResultNodeList().size() == 0;
        }
        return status == 2 || status == 9;
    }

    protected abstract boolean isForwardIteration();

    protected abstract TreeViewer handleActiveWorkbenchParts(List<IWorkbenchPart> var1);
}

