/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class OmnisharpStreamConnectionProvider
implements StreamConnectionProvider {
    private boolean DEBUG = Boolean.parseBoolean(System.getProperty("omnisharp.lsp.debug"));
    private Process process;
    private boolean showDotnetCommandError = true;

    public void start() throws IOException {
        try {
            Process restoreProcess = Runtime.getRuntime().exec(new String[]{AcutePlugin.getDotnetCommand(this.showDotnetCommandError), "restore"});
            this.showDotnetCommandError = true;
            try {
                restoreProcess.waitFor();
            }
            catch (InterruptedException e) {
                AcutePlugin.logError(e);
            }
        }
        catch (IllegalStateException e) {
            this.showDotnetCommandError = false;
            AcutePlugin.getDefault().getLog().log((IStatus)new Status(4, AcutePlugin.getDefault().getBundle().getSymbolicName(), Messages.omnisharpStreamConnection_dotnetRestoreError));
        }
        String commandLine = System.getenv("OMNISHARP_LANGUAGE_SERVER_COMMAND");
        if (commandLine == null) {
            File serverPath = this.getServer();
            commandLine = this.getDefaultCommandLine(serverPath);
        }
        if (commandLine != null) {
            this.process = Runtime.getRuntime().exec(commandLine);
        } else {
            AcutePlugin.getDefault().getLog().log((IStatus)new Status(4, AcutePlugin.getDefault().getBundle().getSymbolicName(), Messages.omnisharpStreamConnection_omnisharpNotFoundError));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @Nullable File getServer() throws IOException {
        File serverPath = new File(AcutePlugin.getDefault().getStateLocation().toFile(), "omnisharp-roslyn");
        if (serverPath.exists()) return serverPath;
        serverPath.mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream stream = FileLocator.openStream((Bundle)AcutePlugin.getDefault().getBundle(), (IPath)new Path("omnisharp-roslyn.tar"), (boolean)true);
            try {
                try (TarArchiveInputStream tarStream = new TarArchiveInputStream(stream);){
                    TarArchiveEntry entry = null;
                    while ((entry = tarStream.getNextTarEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        File targetFile = new File(serverPath, entry.getName());
                        targetFile.getParentFile().mkdirs();
                        BoundedInputStream in = new BoundedInputStream((InputStream)tarStream, entry.getSize());
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (FileOutputStream out = new FileOutputStream(targetFile);){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                            if ("win32".equals(Platform.getOS())) continue;
                            int xDigit = entry.getMode() % 10;
                            targetFile.setExecutable(xDigit > 0, (xDigit & 1) == 1);
                            int wDigit = entry.getMode() / 10 % 10;
                            targetFile.setWritable(wDigit > 0, (wDigit & 1) == 1);
                            int rDigit = entry.getMode() / 100 % 10;
                            targetFile.setReadable(rDigit > 0, (rDigit & 1) == 1);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                }
                if (stream == null) return serverPath;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return serverPath;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    protected @Nullable String getDefaultCommandLine(File serverPath) throws IOException {
        File serverFileUrl = null;
        serverFileUrl = "win32".equals(Platform.getOS()) ? new File(serverPath, "server/Omnisharp.exe") : new File(serverPath, "run");
        if (serverFileUrl == null || !serverFileUrl.exists()) {
            AcutePlugin.logError(NLS.bind((String)Messages.omnisharpStreamConnection_serverNotFoundError, (Object)serverPath));
            return null;
        }
        if (!serverFileUrl.canExecute()) {
            AcutePlugin.logError(NLS.bind((String)Messages.omnisharpStreamConnection_serverNotExecutableError, (Object)serverFileUrl));
        }
        return String.valueOf(serverFileUrl.getAbsolutePath()) + " -stdio -lsp";
    }

    public InputStream getInputStream() {
        if (this.DEBUG) {
            return new FilterInputStream(this.process.getInputStream()){

                @Override
                public int read() throws IOException {
                    int res = super.read();
                    System.err.print((char)res);
                    return res;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    System.err.print(new String(payload));
                    return bytes;
                }

                @Override
                public int read(byte[] b) throws IOException {
                    int bytes = super.read(b);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, 0, payload, 0, bytes);
                    System.err.print(new String(payload));
                    return bytes;
                }
            };
        }
        return this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.DEBUG) {
            return new FilterOutputStream(this.process.getOutputStream()){

                @Override
                public void write(int b) throws IOException {
                    System.err.print((char)b);
                    super.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    System.err.print(new String(b));
                    super.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    byte[] actual = new byte[len];
                    System.arraycopy(b, off, actual, 0, len);
                    System.err.print(new String(actual));
                    super.write(b, off, len);
                }
            };
        }
        return this.process.getOutputStream();
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public @Nullable InputStream getErrorStream() {
        return this.process.getErrorStream();
    }
}

