/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.columnChooser;

import java.util.List;
import net.sourceforge.nattable.columnChooser.ColumnChooserUtils;
import net.sourceforge.nattable.columnChooser.ColumnEntry;
import net.sourceforge.nattable.columnChooser.ColumnGroupEntry;
import net.sourceforge.nattable.columnChooser.ISelectionTreeListener;
import net.sourceforge.nattable.columnChooser.gui.ColumnChooserDialog;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.group.ColumnGroupHeaderLayer;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.command.ColumnGroupExpandCollapseCommand;
import net.sourceforge.nattable.group.command.ReorderColumnGroupCommand;
import net.sourceforge.nattable.group.command.ReorderColumnsAndGroupsCommand;
import net.sourceforge.nattable.hideshow.ColumnHideShowLayer;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.reorder.command.ColumnReorderCommand;
import net.sourceforge.nattable.reorder.command.MultiColumnReorderCommand;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Shell;

public final class ColumnChooser {
    private final ColumnChooserDialog columnChooserDialog;
    private final ColumnHideShowLayer columnHideShowLayer;
    private final DataLayer columnHeaderDataLayer;
    private final ColumnHeaderLayer columnHeaderLayer;
    private List<ColumnEntry> hiddenColumnEntries;
    private List<ColumnEntry> visibleColumnsEntries;
    private final ColumnGroupModel columnGroupModel;
    private final SelectionLayer selectionLayer;

    public ColumnChooser(Shell shell, SelectionLayer selectionLayer, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, ColumnGroupHeaderLayer columnGroupHeaderLayer, ColumnGroupModel columnGroupModel) {
        this.selectionLayer = selectionLayer;
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.columnGroupModel = columnGroupModel;
        this.columnChooserDialog = new ColumnChooserDialog(shell, "Available Columns", "Selected Columns");
    }

    public void openDialog() {
        this.columnChooserDialog.create();
        this.hiddenColumnEntries = ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer);
        this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.columnGroupModel);
        this.visibleColumnsEntries = ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer);
        this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.columnGroupModel);
        this.columnChooserDialog.expandAllLeaves();
        this.addListenersOnColumnChooserDialog();
        this.columnChooserDialog.open();
    }

    private void addListenersOnColumnChooserDialog() {
        this.columnChooserDialog.addListener(new ISelectionTreeListener(){

            @Override
            public void itemsRemoved(List<ColumnEntry> removedItems) {
                ColumnChooserUtils.hideColumnEntries(removedItems, ColumnChooser.this.columnHideShowLayer);
                ColumnChooser.this.refreshColumnChooserDialog();
            }

            @Override
            public void itemsSelected(List<ColumnEntry> addedItems) {
                ColumnChooserUtils.showColumnEntries(addedItems, ColumnChooser.this.columnHideShowLayer);
                ColumnChooser.this.refreshColumnChooserDialog();
            }

            @Override
            public void itemsMoved(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> movedColumnGroupEntries, List<ColumnEntry> movedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
                this.moveItems(direction, movedColumnGroupEntries, movedColumnEntries, fromPositions, toPositions);
            }

            private void moveItems(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> movedColumnGroupEntries, List<ColumnEntry> movedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
                int i = 0;
                while (i < fromPositions.size()) {
                    boolean columnGroupMoved = this.columnGroupMoved(fromPositions.get(i), movedColumnGroupEntries);
                    boolean multipleColumnsMoved = fromPositions.get(i).size() > 1;
                    ILayerCommand command = null;
                    if (!columnGroupMoved && !multipleColumnsMoved) {
                        int fromPosition = fromPositions.get(i).get(0);
                        int toPosition = this.adjustToPosition(direction, (int)toPositions.get(i));
                        command = new ColumnReorderCommand(ColumnChooser.this.columnHideShowLayer, fromPosition, toPosition);
                    } else if (columnGroupMoved && multipleColumnsMoved) {
                        command = new ReorderColumnsAndGroupsCommand(ColumnChooser.this.columnHideShowLayer, fromPositions.get(i), this.adjustToPosition(direction, toPositions.get(i)));
                    } else if (!columnGroupMoved && multipleColumnsMoved) {
                        command = new MultiColumnReorderCommand(ColumnChooser.this.columnHideShowLayer, fromPositions.get(i), this.adjustToPosition(direction, toPositions.get(i)));
                    } else if (columnGroupMoved && !multipleColumnsMoved) {
                        command = new ReorderColumnGroupCommand(ColumnChooser.this.columnHideShowLayer, fromPositions.get(i).get(0), this.adjustToPosition(direction, toPositions.get(i)));
                    }
                    ColumnChooser.this.columnHideShowLayer.doCommand(command);
                    ++i;
                }
                ColumnChooser.this.refreshColumnChooserDialog();
                ColumnChooser.this.columnChooserDialog.setSelectionIncludingNested(ColumnChooserUtils.getColumnEntryIndexes(movedColumnEntries));
            }

            private int adjustToPosition(SelectionLayer.MoveDirectionEnum direction, Integer toColumnPosition) {
                if (SelectionLayer.MoveDirectionEnum.DOWN == direction) {
                    return toColumnPosition + 1;
                }
                return toColumnPosition;
            }

            private boolean columnGroupMoved(List<Integer> fromPositions, List<ColumnGroupEntry> movedColumnGroupEntries) {
                for (ColumnGroupEntry columnGroupEntry : movedColumnGroupEntries) {
                    if (!fromPositions.contains(columnGroupEntry.getFirstElementPosition())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void itemsCollapsed(ColumnGroupEntry columnGroupEntry) {
                int index = columnGroupEntry.getFirstElementIndex();
                int position = ColumnChooser.this.selectionLayer.getColumnPositionByIndex(index);
                ColumnChooser.this.selectionLayer.doCommand(new ColumnGroupExpandCollapseCommand(ColumnChooser.this.selectionLayer, position));
            }

            @Override
            public void itemsExpanded(ColumnGroupEntry columnGroupEntry) {
                int index = columnGroupEntry.getFirstElementIndex();
                int position = ColumnChooser.this.selectionLayer.getColumnPositionByIndex(index);
                ColumnChooser.this.selectionLayer.doCommand(new ColumnGroupExpandCollapseCommand(ColumnChooser.this.selectionLayer, position));
            }
        });
    }

    private void refreshColumnChooserDialog() {
        this.hiddenColumnEntries = ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer);
        this.visibleColumnsEntries = ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer);
        this.columnChooserDialog.removeAllLeaves();
        this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.columnGroupModel);
        this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.columnGroupModel);
        this.columnChooserDialog.expandAllLeaves();
    }
}

