/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractIntSet;

public abstract class AbstractImmutableIntSet
extends AbstractIntSet
implements ImmutableIntSet {
    public ImmutableIntSet newWith(int element) {
        return IntHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableIntSet newWithout(int element) {
        return IntHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return IntHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public IntSet freeze() {
        return this;
    }

    public ImmutableIntSet toImmutable() {
        return this;
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                IntIterator iterator = this.intIterator();
                while (iterator.hasNext()) {
                    MutableIntSet batch = IntSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

