/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc.config;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SP;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.inferencer.fc.config.CustomGraphQueryInferencerSchema;

public final class CustomGraphQueryInferencerConfig
extends AbstractDelegatingSailImplConfig {
    public static final Pattern SPARQL_PATTERN;
    private QueryLanguage language;
    private String ruleQuery;
    private String matcherQuery;

    public CustomGraphQueryInferencerConfig() {
        super("openrdf:CustomGraphQueryInferencer");
    }

    public CustomGraphQueryInferencerConfig(SailImplConfig delegate) {
        super("openrdf:CustomGraphQueryInferencer", delegate);
    }

    public void setQueryLanguage(QueryLanguage language) {
        this.language = language;
    }

    public QueryLanguage getQueryLanguage() {
        return this.language;
    }

    public void setRuleQuery(String ruleQuery) {
        this.ruleQuery = ruleQuery;
    }

    public String getRuleQuery() {
        return this.ruleQuery;
    }

    public void setMatcherQuery(String matcherQuery) {
        this.matcherQuery = null == matcherQuery ? "" : matcherQuery;
    }

    public String getMatcherQuery() {
        return this.matcherQuery;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Optional<Resource> object;
            Optional<Literal> language = Configurations.getLiteralValue(m, implNode, CONFIG.Cgqi.queryLanguage, CustomGraphQueryInferencerSchema.QUERY_LANGUAGE);
            if (language.isPresent()) {
                this.setQueryLanguage(QueryLanguage.valueOf(language.get().stringValue()));
                if (null == this.getQueryLanguage()) {
                    throw new SailConfigException("Valid value required for " + String.valueOf(CONFIG.Cgqi.queryLanguage) + " property, found " + String.valueOf(language.get()));
                }
            } else {
                this.setQueryLanguage(QueryLanguage.SPARQL);
            }
            if ((object = Configurations.getResourceValue(m, implNode, CONFIG.Cgqi.ruleQuery, CustomGraphQueryInferencerSchema.RULE_QUERY)).isPresent()) {
                Models.objectLiteral(m.getStatements(object.get(), SP.TEXT_PROPERTY, null, new Resource[0])).ifPresent(lit -> this.setRuleQuery(lit.stringValue()));
            }
            if ((object = Configurations.getResourceValue(m, implNode, CONFIG.Cgqi.matcherQuery, CustomGraphQueryInferencerSchema.MATCHER_QUERY)).isPresent()) {
                Models.objectLiteral(m.getStatements(object.get(), SP.TEXT_PROPERTY, null, new Resource[0])).ifPresent(lit -> this.setMatcherQuery(lit.stringValue()));
            }
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }

    @Override
    public void validate() throws SailConfigException {
        super.validate();
        if (null == this.language) {
            throw new SailConfigException("No query language specified for " + this.getType() + " Sail.");
        }
        if (null == this.ruleQuery) {
            throw new SailConfigException("No rule query specified for " + this.getType() + " Sail.");
        }
        try {
            QueryParserUtil.parseGraphQuery(this.language, this.ruleQuery, null);
        }
        catch (RDF4JException e) {
            throw new SailConfigException("Problem occured parsing supplied rule query.", e);
        }
        try {
            if (this.matcherQuery.trim().isEmpty()) {
                this.matcherQuery = CustomGraphQueryInferencerConfig.buildMatcherQueryFromRuleQuery(this.language, this.ruleQuery);
            }
            QueryParserUtil.parseGraphQuery(this.language, this.matcherQuery, null);
        }
        catch (RDF4JException e) {
            throw new SailConfigException("Problem occured parsing matcher query: " + this.matcherQuery, e);
        }
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        if (null != this.language) {
            m.add(implNode, CONFIG.Cgqi.queryLanguage, Values.literal(this.language.getName()), new Resource[0]);
        }
        this.addQueryNode(m, implNode, CONFIG.Cgqi.ruleQuery, this.ruleQuery);
        this.addQueryNode(m, implNode, CONFIG.Cgqi.matcherQuery, this.matcherQuery);
        return implNode;
    }

    public static String buildMatcherQueryFromRuleQuery(QueryLanguage language, String ruleQuery) throws MalformedQueryException {
        Object result = "";
        if (QueryLanguage.SPARQL == language) {
            Matcher matcher = SPARQL_PATTERN.matcher(ruleQuery);
            if (matcher.matches()) {
                result = matcher.group(1) + "WHERE" + matcher.group(2);
            }
        } else {
            throw new IllegalStateException("language");
        }
        return result;
    }

    private void addQueryNode(Model m, Resource implNode, IRI predicate, String queryText) {
        if (null != queryText) {
            BNode queryNode = Values.bnode();
            m.add(implNode, predicate, queryNode, new Resource[0]);
            m.add(queryNode, RDF.TYPE, SP.CONSTRUCT_CLASS, new Resource[0]);
            m.add(queryNode, SP.TEXT_PROPERTY, Values.literal(queryText), new Resource[0]);
        }
    }

    static {
        int flags = 34;
        SPARQL_PATTERN = Pattern.compile("^(.*construct\\s+)(\\{.*\\}\\s*)where.*$", flags);
    }
}

