/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractSimpleConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.DatatypeFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class DatatypeConstraintComponent
extends AbstractSimpleConstraintComponent {
    private final CoreDatatype coreDatatype;
    private final IRI datatype;

    public DatatypeConstraintComponent(IRI datatype) {
        this.datatype = datatype;
        this.coreDatatype = CoreDatatype.from(datatype);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.DATATYPE, this.datatype, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.DatatypeConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new DatatypeConstraintComponent(this.datatype);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher(ConnectionsGroup connectionsGroup) {
        return parent -> new DatatypeFilter((PlanNode)parent, this.datatype, connectionsGroup);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        String checkDatatypeConformance = "<" + RSX.valueConformsToXsdDatatypeFunction + ">(" + variable.asSparqlVariable() + ", <" + this.datatype + ">)";
        if (negated) {
            return "isLiteral(" + variable.asSparqlVariable() + ") && datatype(" + variable.asSparqlVariable() + ") = <" + this.datatype + ">" + (String)(this.coreDatatype.isXSDDatatype() ? " && " + checkDatatypeConformance : "");
        }
        return "!isLiteral(" + variable.asSparqlVariable() + ") || datatype(" + variable.asSparqlVariable() + ") != <" + this.datatype + ">" + (String)(this.coreDatatype.isXSDDatatype() ? " || !" + checkDatatypeConformance : "");
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatatypeConstraintComponent that = (DatatypeConstraintComponent)o;
        return this.datatype.equals(that.datatype);
    }

    public int hashCode() {
        return this.datatype.hashCode() + "DatatypeConstraintComponent".hashCode();
    }
}

