/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Severity
extends Enum<Severity> {
    public static final /* enum */ Severity Info = new Severity(SHACL.INFO);
    public static final /* enum */ Severity Warning = new Severity(SHACL.WARNING);
    public static final /* enum */ Severity Violation = new Severity(SHACL.VIOLATION);
    private static final Logger logger;
    private final Value iri;
    private static final /* synthetic */ Severity[] $VALUES;

    public static Severity[] values() {
        return (Severity[])$VALUES.clone();
    }

    public static Severity valueOf(String name) {
        return Enum.valueOf(Severity.class, name);
    }

    private Severity(Value iri) {
        this.iri = iri;
    }

    public static Severity fromIri(IRI iri) {
        if (iri == null) {
            return null;
        }
        if (iri == SHACL.VIOLATION) {
            return Violation;
        }
        if (iri == SHACL.WARNING) {
            return Warning;
        }
        if (iri == SHACL.INFO) {
            return Info;
        }
        if (Severity.Info.iri.equals(iri)) {
            return Info;
        }
        if (Severity.Warning.iri.equals(iri)) {
            return Warning;
        }
        if (Severity.Violation.iri.equals(iri)) {
            return Violation;
        }
        logger.warn("Unknown sh:severity: <{}>", (Object)iri);
        return null;
    }

    public static Severity orDefault(Severity severity) {
        if (severity == null) {
            return Violation;
        }
        return severity;
    }

    public Value getIri() {
        return this.iri;
    }

    static {
        $VALUES = new Severity[]{Info, Warning, Violation};
        logger = LoggerFactory.getLogger(Severity.class);
        assert (Severity.values().length == 3);
    }
}

