/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.aggregate;

import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.aggregate.StatisticCollector;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.AggregateFunction;

@Experimental
public class StatisticalAggregateFunction
extends AggregateFunction<StatisticCollector, Value> {
    public StatisticalAggregateFunction(Function<BindingSet, Value> evaluationStep) {
        super(evaluationStep);
    }

    @Override
    public void processAggregate(BindingSet bindingSet, Predicate<Value> distinctValue, StatisticCollector collector) throws QueryEvaluationException {
        if (collector.hasError()) {
            return;
        }
        Value v = this.evaluate(bindingSet);
        if (distinctValue.test(v)) {
            if (v instanceof Literal) {
                Literal nextLiteral = (Literal)v;
                if (((Literal)v).getCoreDatatype().asXSDDatatype().orElseThrow(() -> new ValueExprEvaluationException("not an XSD type literal: " + v)).isNumericDatatype()) {
                    collector.addValue(nextLiteral);
                } else {
                    collector.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                }
            } else if (v != null) {
                collector.setTypeError(new ValueExprEvaluationException("not a literal: " + v));
            }
        }
    }
}

