/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.multimap.ImmutableMultimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionMutableCollection;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;

public final class IteratorIterate {
    private IteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        MutableList positiveResult = Lists.mutable.empty();
        MutableList negativeResult = Lists.mutable.empty();
        while (iterator.hasNext()) {
            T item = iterator.next();
            (predicate.accept(item, parameter) ? positiveResult : negativeResult).add(item);
        }
        return Tuples.twin(positiveResult, negativeResult);
    }

    public static <T> PartitionMutableList<T> partition(Iterator<T> iterator, Predicate<? super T> predicate) {
        PartitionFastList result = new PartitionFastList();
        MutableList selected = result.getSelected();
        MutableList rejected = result.getRejected();
        while (iterator.hasNext()) {
            T each = iterator.next();
            MutableList bucket = predicate.accept(each) ? selected : rejected;
            bucket.add(each);
        }
        return result;
    }

    public static <T, P> PartitionMutableList<T> partitionWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionFastList result = new PartitionFastList();
        MutableList selected = result.getSelected();
        MutableList rejected = result.getRejected();
        while (iterator.hasNext()) {
            T each = iterator.next();
            MutableList bucket = predicate.accept(each, parameter) ? selected : rejected;
            bucket.add(each);
        }
        return result;
    }

    public static <T, R extends PartitionMutableCollection<T>> R partitionWhile(Iterator<T> iterator, Predicate<? super T> predicate, R target) {
        MutableCollection selected = target.getSelected();
        MutableCollection rejected = target.getRejected();
        boolean partitionFound = false;
        while (iterator.hasNext() && !partitionFound) {
            T next = iterator.next();
            if (predicate.accept(next)) {
                selected.add(next);
                continue;
            }
            rejected.add(next);
            partitionFound = true;
        }
        while (iterator.hasNext()) {
            rejected.add(iterator.next());
        }
        return target;
    }

    public static <T, R extends MutableCollection<T>> R takeWhile(Iterator<T> iterator, Predicate<? super T> predicate, R target) {
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (predicate.accept(next)) {
                target.add(next);
                continue;
            }
            return target;
        }
        return target;
    }

    public static <T, R extends MutableCollection<T>> R dropWhile(Iterator<T> iterator, Predicate<? super T> predicate, R target) {
        boolean partitionFound = false;
        while (iterator.hasNext() && !partitionFound) {
            T next = iterator.next();
            if (predicate.accept(next)) continue;
            target.add(next);
            partitionFound = true;
        }
        while (iterator.hasNext()) {
            target.add(iterator.next());
        }
        return target;
    }

    public static <T> int count(Iterator<T> iterator, Predicate<? super T> predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static <T, P> int countWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next(), parameter)) continue;
            ++count;
        }
        return count;
    }

    public static <T, R extends Collection<T>> R select(Iterator<T> iterator, Predicate<? super T> predicate, R targetCollection) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R selectWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P injectedValue, R targetCollection) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!predicate.accept(item, injectedValue)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, R extends Collection<T>> R selectInstancesOf(Iterator<?> iterator, Class<T> clazz, R targetCollection) {
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (!clazz.isInstance(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterator<T> iterator, Predicate<? super T> predicate, Function<? super T, ? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add((Object)function.valueOf(item));
        }
        return targetCollection;
    }

    public static <T, R extends Collection<T>> R reject(Iterator<T> iterator, Predicate<? super T> predicate, R targetCollection) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R rejectWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (predicate.accept(item, parameter)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, V, R extends Collection<V>> R collect(Iterator<T> iterator, Function<? super T, ? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            targetCollection.add((Object)function.valueOf(iterator.next()));
        }
        return targetCollection;
    }

    public static <T> MutableBooleanCollection collectBoolean(Iterator<T> iterator, BooleanFunction<? super T> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList();
        while (iterator.hasNext()) {
            result.add(booleanFunction.booleanValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(Iterator<T> iterator, BooleanFunction<? super T> booleanFunction, R target) {
        while (iterator.hasNext()) {
            target.add(booleanFunction.booleanValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableByteCollection collectByte(Iterator<T> iterator, ByteFunction<? super T> byteFunction) {
        ByteArrayList result = new ByteArrayList();
        while (iterator.hasNext()) {
            result.add(byteFunction.byteValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableByteCollection> R collectByte(Iterator<T> iterator, ByteFunction<? super T> byteFunction, R target) {
        while (iterator.hasNext()) {
            target.add(byteFunction.byteValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableCharCollection collectChar(Iterator<T> iterator, CharFunction<? super T> charFunction) {
        CharArrayList result = new CharArrayList();
        while (iterator.hasNext()) {
            result.add(charFunction.charValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableCharCollection> R collectChar(Iterator<T> iterator, CharFunction<? super T> charFunction, R target) {
        while (iterator.hasNext()) {
            target.add(charFunction.charValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableDoubleCollection collectDouble(Iterator<T> iterator, DoubleFunction<? super T> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList();
        while (iterator.hasNext()) {
            result.add(doubleFunction.doubleValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(Iterator<T> iterator, DoubleFunction<? super T> doubleFunction, R target) {
        while (iterator.hasNext()) {
            target.add(doubleFunction.doubleValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableFloatCollection collectFloat(Iterator<T> iterator, FloatFunction<? super T> floatFunction) {
        FloatArrayList result = new FloatArrayList();
        while (iterator.hasNext()) {
            result.add(floatFunction.floatValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(Iterator<T> iterator, FloatFunction<? super T> floatFunction, R target) {
        while (iterator.hasNext()) {
            target.add(floatFunction.floatValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableIntCollection collectInt(Iterator<T> iterator, IntFunction<? super T> intFunction) {
        IntArrayList result = new IntArrayList();
        while (iterator.hasNext()) {
            result.add(intFunction.intValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableIntCollection> R collectInt(Iterator<T> iterator, IntFunction<? super T> intFunction, R target) {
        while (iterator.hasNext()) {
            target.add(intFunction.intValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableLongCollection collectLong(Iterator<T> iterator, LongFunction<? super T> longFunction) {
        LongArrayList result = new LongArrayList();
        while (iterator.hasNext()) {
            result.add(longFunction.longValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableLongCollection> R collectLong(Iterator<T> iterator, LongFunction<? super T> longFunction, R target) {
        while (iterator.hasNext()) {
            target.add(longFunction.longValueOf(iterator.next()));
        }
        return target;
    }

    public static <T> MutableShortCollection collectShort(Iterator<T> iterator, ShortFunction<? super T> shortFunction) {
        ShortArrayList result = new ShortArrayList();
        while (iterator.hasNext()) {
            result.add(shortFunction.shortValueOf(iterator.next()));
        }
        return result;
    }

    public static <T, R extends MutableShortCollection> R collectShort(Iterator<T> iterator, ShortFunction<? super T> shortFunction, R target) {
        while (iterator.hasNext()) {
            target.add(shortFunction.shortValueOf(iterator.next()));
        }
        return target;
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterator<T> iterator, Function<? super T, ? extends Iterable<V>> function, R targetCollection) {
        while (iterator.hasNext()) {
            Iterate.addAllTo((Iterable)function.valueOf(iterator.next()), targetCollection);
        }
        return targetCollection;
    }

    public static <T> void forEach(Iterator<T> iterator, Procedure<? super T> procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <T> void forEachWithIndex(Iterator<T> iterator, ObjectIntProcedure<? super T> objectIntProcedure) {
        int i = 0;
        while (iterator.hasNext()) {
            objectIntProcedure.value(iterator.next(), i++);
        }
    }

    public static <T> T detect(Iterator<T> iterator, Predicate<? super T> predicate) {
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each)) continue;
            return each;
        }
        return null;
    }

    public static <T, P> T detectWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each, parameter)) continue;
            return each;
        }
        return null;
    }

    public static <T> Optional<T> detectOptional(Iterator<T> iterator, Predicate<? super T> predicate) {
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public static <T, P> Optional<T> detectWithOptional(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each, parameter)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public static <T, IV> IV injectInto(IV injectValue, Iterator<T> iterator, Function2<? super IV, ? super T, ? extends IV> function) {
        Object result = injectValue;
        while (iterator.hasNext()) {
            result = function.value(result, iterator.next());
        }
        return result;
    }

    public static <T> int injectInto(int injectValue, Iterator<T> iterator, IntObjectToIntFunction<? super T> function) {
        int result = injectValue;
        while (iterator.hasNext()) {
            result = function.intValueOf(result, iterator.next());
        }
        return result;
    }

    public static <T> long injectInto(long injectValue, Iterator<T> iterator, LongObjectToLongFunction<? super T> function) {
        long result = injectValue;
        while (iterator.hasNext()) {
            result = function.longValueOf(result, iterator.next());
        }
        return result;
    }

    public static <T> double injectInto(double injectValue, Iterator<T> iterator, DoubleObjectToDoubleFunction<? super T> function) {
        double result = injectValue;
        while (iterator.hasNext()) {
            result = function.doubleValueOf(result, iterator.next());
        }
        return result;
    }

    public static <T> float injectInto(float injectValue, Iterator<T> iterator, FloatObjectToFloatFunction<? super T> function) {
        float result = injectValue;
        while (iterator.hasNext()) {
            result = function.floatValueOf(result, iterator.next());
        }
        return result;
    }

    public static <T, IV, P> IV injectIntoWith(IV injectValue, Iterator<T> iterator, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        Object result = injectValue;
        while (iterator.hasNext()) {
            result = function.value(result, iterator.next(), parameter);
        }
        return result;
    }

    public static <T> boolean shortCircuit(Iterator<T> iterator, Predicate<? super T> predicate, boolean expected, boolean onShortCircuit, boolean atEnd) {
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (predicate.accept(each) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }

    public static <T, P> boolean shortCircuitWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate2, P parameter, boolean expected, boolean onShortCircuit, boolean atEnd) {
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (predicate2.accept(each, parameter) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }

    public static <T> boolean anySatisfy(Iterator<T> iterator, Predicate<? super T> predicate) {
        return IteratorIterate.shortCircuit(iterator, predicate, true, true, false);
    }

    public static <T, P> boolean anySatisfyWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        return IteratorIterate.shortCircuitWith(iterator, predicate, parameter, true, true, false);
    }

    public static <T> boolean allSatisfy(Iterator<T> iterator, Predicate<? super T> predicate) {
        return IteratorIterate.shortCircuit(iterator, predicate, false, false, true);
    }

    public static <T, P> boolean allSatisfyWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        return IteratorIterate.shortCircuitWith(iterator, predicate, parameter, false, false, true);
    }

    public static <T> boolean noneSatisfy(Iterator<T> iterator, Predicate<? super T> predicate) {
        return IteratorIterate.shortCircuit(iterator, predicate, true, false, true);
    }

    public static <T, P> boolean noneSatisfyWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        return IteratorIterate.shortCircuitWith(iterator, predicate, parameter, true, false, true);
    }

    public static <T> boolean removeIf(Iterator<T> iterator, Predicate<? super T> predicate) {
        boolean changed = false;
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public static <T, P> boolean removeIfWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter) {
        boolean changed = false;
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each, parameter)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public static <T> boolean removeIf(Iterator<T> iterator, Predicate<? super T> predicate, Procedure<? super T> procedure) {
        boolean changed = false;
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each)) continue;
            procedure.value(each);
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public static <T, P> boolean removeIfWith(Iterator<T> iterator, Predicate2<? super T, ? super P> predicate, P parameter, Procedure<? super T> procedure) {
        boolean changed = false;
        while (iterator.hasNext()) {
            T each = iterator.next();
            if (!predicate.accept(each, parameter)) continue;
            procedure.value(each);
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public static <T> int detectIndex(Iterator<T> iterator, Predicate<? super T> predicate) {
        int i = 0;
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, IV> int detectIndexWith(Iterator<T> iterator, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int i = 0;
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next(), injectedValue)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, P> void forEachWith(Iterator<T> iterator, Procedure2<? super T, ? super P> procedure, P parameter) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next(), parameter);
        }
    }

    public static <T, P, A, R extends Collection<A>> R collectWith(Iterator<T> iterator, Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        while (iterator.hasNext()) {
            targetCollection.add((Object)function.value(iterator.next(), parameter));
        }
        return targetCollection;
    }

    public static <T, V> ImmutableMultimap<V, T> groupBy(Iterator<T> iterator, Function<? super T, ? extends V> function) {
        return IteratorIterate.groupBy(iterator, function, new FastListMultimap()).toImmutable();
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(Iterator<T> iterator, Function<? super T, ? extends V> function, R target) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            target.put(function.valueOf(item), item);
        }
        return target;
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(Iterator<T> iterator, Function<? super T, ? extends Iterable<V>> function, R target) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            Iterable iterable = (Iterable)function.valueOf(item);
            for (Object key : iterable) {
                target.put(key, item);
            }
        }
        return target;
    }

    public static <K, T, R extends MutableMapIterable<K, T>> R groupByUniqueKey(Iterator<T> iterator, Function<? super T, ? extends K> function, R target) {
        while (iterator.hasNext()) {
            T value = iterator.next();
            Object key = function.valueOf(value);
            if (target.put(key, value) == null) continue;
            throw new IllegalStateException("Key " + key + " already exists in map!");
        }
        return target;
    }

    @Deprecated
    public static <T, R extends List<T>> R distinct(Iterator<T> iterator, R targetCollection) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!seenSoFar.add(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T> MutableList<T> distinct(Iterator<T> iterator) {
        return IteratorIterate.distinct(iterator, FastList.newList());
    }

    public static <T> MutableList<T> distinct(Iterator<T> iterator, HashingStrategy<? super T> hashingStrategy) {
        UnifiedSetWithHashingStrategy<T> seenSoFar = UnifiedSetWithHashingStrategy.newSet(hashingStrategy);
        FastList result = FastList.newList();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!seenSoFar.add(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(Iterator<X> xs, Iterator<Y> ys, R target) {
        while (xs.hasNext() && ys.hasNext()) {
            target.add(Tuples.pair(xs.next(), ys.next()));
        }
        return target;
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(Iterator<T> iterator, R target) {
        int index = 0;
        while (iterator.hasNext()) {
            target.add(Tuples.pair(iterator.next(), index));
            ++index;
        }
        return target;
    }

    public static <T> RichIterable<RichIterable<T>> chunk(Iterator<T> iterator, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        while (iterator.hasNext()) {
            MutableList batch = Lists.mutable.empty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add((Object)batch);
        }
        return result;
    }

    public static <T> T min(Iterator<T> iterator, Comparator<? super T> comparator) {
        T min = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (comparator.compare(next, min) >= 0) continue;
            min = next;
        }
        return min;
    }

    public static <T> T max(Iterator<T> iterator, Comparator<? super T> comparator) {
        T max = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (comparator.compare(next, max) <= 0) continue;
            max = next;
        }
        return max;
    }

    public static <T> Iterator<T> advanceIteratorTo(Iterator<T> iterator, int from) {
        for (int i = 0; i < from; ++i) {
            iterator.next();
        }
        return iterator;
    }

    public static <T> long sumOfInt(Iterator<T> iterator, IntFunction<? super T> function) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += (long)function.intValueOf(iterator.next());
        }
        return sum;
    }

    public static <T> long sumOfLong(Iterator<T> iterator, LongFunction<? super T> function) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += function.longValueOf(iterator.next());
        }
        return sum;
    }

    public static <T> double sumOfFloat(Iterator<T> iterator, FloatFunction<? super T> function) {
        double sum = 0.0;
        double compensation = 0.0;
        while (iterator.hasNext()) {
            double adjustedValue = (double)function.floatValueOf(iterator.next()) - compensation;
            double nextSum = sum + adjustedValue;
            compensation = nextSum - sum - adjustedValue;
            sum = nextSum;
        }
        return sum;
    }

    public static <T> double sumOfDouble(Iterator<T> iterator, DoubleFunction<? super T> function) {
        double sum = 0.0;
        double compensation = 0.0;
        while (iterator.hasNext()) {
            double adjustedValue = function.doubleValueOf(iterator.next()) - compensation;
            double nextSum = sum + adjustedValue;
            compensation = nextSum - sum - adjustedValue;
            sum = nextSum;
        }
        return sum;
    }

    public static <T> BigDecimal sumOfBigDecimal(Iterator<T> iterator, Function<? super T, BigDecimal> function) {
        BigDecimal result = BigDecimal.ZERO;
        while (iterator.hasNext()) {
            result = result.add((BigDecimal)function.valueOf(iterator.next()));
        }
        return result;
    }

    public static <T> BigInteger sumOfBigInteger(Iterator<T> iterator, Function<? super T, BigInteger> function) {
        BigInteger result = BigInteger.ZERO;
        while (iterator.hasNext()) {
            result = result.add((BigInteger)function.valueOf(iterator.next()));
        }
        return result;
    }

    public static <V, T> MutableMap<V, BigDecimal> sumByBigDecimal(Iterator<T> iterator, Function<? super T, ? extends V> groupBy, Function<? super T, BigDecimal> function) {
        UnifiedMap result = UnifiedMap.newMap();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            result.updateValue(groupBy.valueOf(item), Functions0.zeroBigDecimal(), (Function & Serializable)original -> original.add((BigDecimal)function.valueOf(item)));
        }
        return result;
    }

    public static <V, T> MutableMap<V, BigInteger> sumByBigInteger(Iterator<T> iterator, Function<? super T, ? extends V> groupBy, Function<? super T, BigInteger> function) {
        UnifiedMap result = UnifiedMap.newMap();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            result.updateValue(groupBy.valueOf(item), Functions0.zeroBigInteger(), (Function & Serializable)original -> original.add((BigInteger)function.valueOf(item)));
        }
        return result;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterator<T> iterator, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        IteratorIterate.forEach(iterator, new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterator<T> iterator, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        IteratorIterate.forEach(iterator, new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public static <T, V extends Comparable<? super V>> T minBy(Iterator<T> iterator, Function<? super T, ? extends V> function) {
        T min = iterator.next();
        Comparable minValue = (Comparable)function.valueOf(min);
        while (iterator.hasNext()) {
            T next = iterator.next();
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            minValue = nextValue;
        }
        return min;
    }

    public static <T, V extends Comparable<? super V>> T maxBy(Iterator<T> iterator, Function<? super T, ? extends V> function) {
        T max = iterator.next();
        Comparable maxValue = (Comparable)function.valueOf(max);
        while (iterator.hasNext()) {
            T next = iterator.next();
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            maxValue = nextValue;
        }
        return max;
    }
}

