/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableCharCharMapFactory;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.impl.factory.primitive.CharCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharSingletonMap;

public enum ImmutableCharCharMapFactoryImpl implements ImmutableCharCharMapFactory
{
    INSTANCE;


    public ImmutableCharCharMap empty() {
        return ImmutableCharCharEmptyMap.INSTANCE;
    }

    public ImmutableCharCharMap of() {
        return this.empty();
    }

    public ImmutableCharCharMap with() {
        return this.empty();
    }

    public ImmutableCharCharMap of(char key, char value) {
        return this.with(key, value);
    }

    public ImmutableCharCharMap with(char key, char value) {
        return new ImmutableCharCharSingletonMap(key, value);
    }

    public ImmutableCharCharMap ofAll(CharCharMap map) {
        return this.withAll(map);
    }

    public ImmutableCharCharMap withAll(CharCharMap map) {
        if (map instanceof ImmutableCharCharMap) {
            return (ImmutableCharCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharCharSingletonMap(key, map.get(key));
        }
        return new ImmutableCharCharHashMap(map);
    }

    public <T> ImmutableCharCharMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        return CharCharMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

