/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.utils;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.rcptt.util.StringUtils;

public class Cryptography {
    private static final byte[] IV_PARAMETER_SPEC = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final byte[] SALT = new byte[8];
    private static final String CIPHER_MODE = "AES/CBC/PKCS5Padding";
    private static final String PROPERTY = "org.eclipse.rcptt.cryptoKey";
    private Key key;
    public static final Cryptography INSTANCE = new Cryptography(Cryptography.getConfiguredKey());

    public Cryptography(Key key) {
        this.key = key;
        if (key == null) {
            throw new NullPointerException();
        }
    }

    public String decrypt(String input) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, this.key, new IvParameterSpec(IV_PARAMETER_SPEC));
            return new String(cipher.doFinal(Base64.decode((String)input)), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encrypt(String input) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, this.key, new IvParameterSpec(IV_PARAMETER_SPEC));
            return Base64.encode((byte[])cipher.doFinal(input.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Key getConfiguredKey() {
        String keyString = System.getProperty(PROPERTY);
        if (StringUtils.isEmpty((String)keyString)) {
            keyString = "gjdlm7JIO.UOLNE/EOL<FPUWX MI<KMG2TYIL";
        }
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(keyString.toCharArray(), SALT, 256, 128);
            byte[] encoded = factory.generateSecret(spec).getEncoded();
            assert (encoded.length * 8 == 128);
            SecretKeySpec rv = new SecretKeySpec(encoded, "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, (Key)rv, new IvParameterSpec(IV_PARAMETER_SPEC));
            return rv;
        }
        catch (Exception e) {
            throw new RuntimeException("Cryptography key failure.", e);
        }
    }
}

