/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.ui.actions;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.internal.ui.RCPTTResourcesUI;
import org.eclipse.rcptt.resources.ui.actions.PersistenceEditorInput;
import org.eclipse.rcptt.resources.ui.imports.ExternalProjectImportWizard;
import org.eclipse.rcptt.resources.ui.wizards.FileSystemImportWizard;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.rcptt.workspace.WSContainer;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSProjectLink;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class WSAction
extends Action {
    protected WSResource[] selection;
    protected TreeViewer viewer;

    public WSAction(String text, ImageDescriptor descriptor) {
        super(text, descriptor);
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    protected WorkspaceData getWorkspaceData() {
        return (WorkspaceData)this.viewer.getInput();
    }

    public void setSelection(WSResource[] selection) {
        this.selection = selection;
        this.init();
    }

    protected abstract void init();

    private static <T extends WSResource> void addResource(List<T> resources, String prefix, T newResource, boolean noPostfixIfPossible) {
        HashSet<String> names = new HashSet<String>();
        for (WSResource resource : resources) {
            names.add(resource.getName());
        }
        int i = 1;
        while (true) {
            String name = prefix + i;
            if (noPostfixIfPossible && !names.contains(prefix)) {
                newResource.setName(prefix);
                resources.add(newResource);
                return;
            }
            if (!names.contains(name)) {
                newResource.setName(name);
                resources.add(newResource);
                return;
            }
            ++i;
        }
    }

    public static class AddFile
    extends WSAction {
        public AddFile() {
            super("New File", Images.getImageDescriptor((String)"icons/newFile.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && this.selection[0] instanceof WSFolder);
        }

        public void run() {
            WSFolder container = (WSFolder)this.selection[0];
            WSFile file = WorkspaceFactory.eINSTANCE.createWSFile();
            WSAction.addResource(container.getFiles(), "file", file, false);
            this.viewer.setExpandedState((Object)container, true);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)file), true);
            this.viewer.editElement((Object)file, 0);
        }
    }

    public static class AddFolder
    extends WSAction {
        public AddFolder() {
            super("Create Empty Folder", Images.getImageDescriptor((String)"icons/newFolder.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && this.selection[0] instanceof WSFolder);
        }

        public void run() {
            WSFolder container = (WSFolder)this.selection[0];
            WSFolder folder = WorkspaceFactory.eINSTANCE.createWSFolder();
            WSAction.addResource(container.getFolders(), "folder", folder, false);
            this.viewer.setExpandedState((Object)container, true);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)folder), true);
            this.viewer.editElement((Object)folder, 0);
        }
    }

    public static class AddProject
    extends WSAction {
        public AddProject() {
            super("Create Empty Project", Images.getImageDescriptor((String)"icons/newProject.gif"));
        }

        @Override
        protected void init() {
        }

        public void run() {
            WSProject project = WorkspaceFactory.eINSTANCE.createWSProject();
            WSAction.addResource(this.getWorkspaceData().getContent().getProjects(), "project", project, false);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)project), true);
            this.viewer.editElement((Object)project, 0);
        }
    }

    protected static abstract class CreateElement
    extends WSAction {
        public CreateElement(String text, ImageDescriptor descriptor) {
            super(text, descriptor);
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && this.selection[0] instanceof WSFolder);
        }

        public void run() {
            WSFolder container = this.getContainer();
            WSResource res = this.create();
            WSAction.addResource(this.getContents(container), this.getNamePrefix(), res, false);
            this.viewer.setExpandedState((Object)container, true);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)res), true);
            this.viewer.editElement((Object)res, 0);
        }

        protected abstract WSResource create();

        protected abstract String getNamePrefix();

        protected WSFolder getContainer() {
            return (WSFolder)this.selection[0];
        }

        protected List<WSResource> getContents(WSFolder container) {
            return WSUtils.getContents((WSContainer)container);
        }
    }

    public static class ImportFiles
    extends WSAction {
        public ImportFiles() {
            super("Import Files...", Images.getImageDescriptor((String)"icons/importFiles.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && this.selection[0] instanceof WSFolder);
        }

        public void run() {
            WSFolder folder = (WSFolder)this.selection[0];
            FileSystemImportWizard wizard = new FileSystemImportWizard((WSContainer)folder);
            WizardDialog dialog = new WizardDialog(WorkbenchUtils.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static class ImportProjects
    extends WSAction {
        public ImportProjects() {
            super("Import Projects...", Images.getImageDescriptor((String)"icons/importProjects.gif"));
        }

        @Override
        protected void init() {
        }

        public void run() {
            ExternalProjectImportWizard wizard = new ExternalProjectImportWizard(this.getWorkspaceData(), null);
            WizardDialog dialog = new WizardDialog(WorkbenchUtils.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static class LinkFiles
    extends WSAction {
        public LinkFiles() {
            super("Link Workspace Files...", Images.getImageDescriptor((String)"icons/link-file.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && this.selection[0] instanceof WSFolder);
        }

        public void run() {
            Object[] selection;
            WSFolder folder = (WSFolder)this.selection[0];
            CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(WorkbenchUtils.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setTitle("File Selection");
            dialog.setMessage("Please select files:");
            dialog.setContainerMode(true);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof IFile) {
                            return new Status(0, "org.eclipse.rcptt.resources.ui", "");
                        }
                        ++n2;
                    }
                    return new Status(4, "org.eclipse.rcptt.resources.ui", "Select one or more files.");
                }
            });
            IDialogSettings settings = RCPTTResourcesUI.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection("LinkFilesDialog.bounds");
            if (section == null) {
                section = settings.addNewSection("LinkFilesDialog.bounds");
            }
            dialog.setDialogBoundsSettings(section, 2);
            if (dialog.open() != 0) {
                return;
            }
            Object[] objectArray = selection = dialog.getResult();
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof IFile) {
                    IFile file = (IFile)o;
                    WSFileLink link = WorkspaceFactory.eINSTANCE.createWSFileLink();
                    link.setName(file.getName());
                    link.setProject(file.getProject().getName());
                    link.setPath(file.getProjectRelativePath().toPortableString());
                    WSAction.addResource(folder.getFileLinks(), link.getName(), link, true);
                }
                ++n2;
            }
        }
    }

    public static class LinkFolder
    extends WSAction {
        public LinkFolder() {
            super("Link Workspace Folder...", Images.getImageDescriptor((String)"icons/link-folder.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && (this.selection[0] instanceof WSFolder || this.selection[0] instanceof WSProject));
        }

        public void run() {
            Object[] selection;
            WSFolder folder = (WSFolder)this.selection[0];
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(WorkbenchUtils.getShell(), null, false, "Please select a folder:");
            IDialogSettings settings = RCPTTResourcesUI.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection("LinkFolderDialog.bounds");
            if (section == null) {
                section = settings.addNewSection("LinkFolderDialog.bounds");
            }
            dialog.setDialogBoundsSettings(section, 2);
            if (dialog.open() != 0) {
                return;
            }
            Object[] objectArray = selection = dialog.getResult();
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IFolder c;
                    block8: {
                        IPath path;
                        block7: {
                            Object o = objectArray[n2];
                            if (!(o instanceof IPath)) break block6;
                            path = (IPath)o;
                            if (path.segmentCount() <= 1) break block7;
                            c = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                            break block8;
                        }
                        if (path.segmentCount() != 1) break block6;
                        c = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                    }
                    WSFolderLink link = WorkspaceFactory.eINSTANCE.createWSFolderLink();
                    link.setName(c.getName());
                    link.setProject(c.getProject().getName());
                    link.setPath(c.getProjectRelativePath().toPortableString());
                    WSAction.addResource(folder.getFolderLinks(), link.getName(), link, true);
                }
                ++n2;
            }
        }
    }

    public static class LinkProject
    extends WSAction {
        public LinkProject() {
            super("Link Workspace Project...", Images.getImageDescriptor((String)"icons/link-project.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(true);
        }

        public void run() {
            Object[] selection;
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(WorkbenchUtils.getShell(), null, false, "Please select a project:");
            dialog.setTitle("Project Selection");
            IDialogSettings settings = RCPTTResourcesUI.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection("LinkProjectDialog.bounds");
            if (section == null) {
                section = settings.addNewSection("LinkProjectDialog.bounds");
            }
            dialog.setDialogBoundsSettings(section, 2);
            dialog.setValidator(new ISelectionValidator(){

                public String isValid(Object selection) {
                    if (!(selection instanceof IPath)) {
                        return "Unsupported selection type.";
                    }
                    IPath path = (IPath)selection;
                    if (path.segmentCount() == 1) {
                        return null;
                    }
                    if (path.segmentCount() > 1) {
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                        IResource dotProject = folder.findMember(".project");
                        return dotProject != null && dotProject.exists() && dotProject instanceof IFile ? null : "Selected folder is not a project.";
                    }
                    return "Unsupported selection type.";
                }
            });
            if (dialog.open() != 0) {
                return;
            }
            Object[] objectArray = selection = dialog.getResult();
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IFolder c;
                    block8: {
                        IPath path;
                        block7: {
                            Object o = objectArray[n2];
                            if (!(o instanceof IPath)) break block6;
                            path = (IPath)o;
                            if (path.segmentCount() <= 1) break block7;
                            c = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                            break block8;
                        }
                        if (path.segmentCount() != 1) break block6;
                        c = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                    }
                    WSProjectLink link = WorkspaceFactory.eINSTANCE.createWSProjectLink();
                    link.setName(c.getName());
                    link.setProject(c.getProject().getName());
                    link.setPath(c.getProjectRelativePath().toPortableString());
                    WSAction.addResource(this.getWorkspaceData().getContent().getProjectLinks(), link.getName(), link, true);
                }
                ++n2;
            }
        }
    }

    public static class OpenFile
    extends WSAction {
        public OpenFile() {
            super("Open File", Images.getImageDescriptor((String)"icons/file.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && (this.selection[0] instanceof WSFile || this.selection[0] instanceof WSFileLink));
        }

        public void run() {
            if (this.selection[0] instanceof WSFile) {
                WSFile file = (WSFile)this.selection[0];
                String name = ImportUtils.getName((WSFile)file);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new PersistenceEditorInput(this.getWorkspaceData().eResource(), name), (String)"org.eclipse.ui.DefaultTextEditor");
                }
                catch (PartInitException e) {
                    Q7UIPlugin.log((Throwable)e);
                }
            } else {
                WSFileLink link = (WSFileLink)this.selection[0];
                String name = link.getName();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)name, (boolean)true);
                    String id = null;
                    id = descriptor != null ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
                    IFile linkResource = WSUtils.getLinkResource((WSLink)link);
                    if (linkResource != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)linkResource, (String)id, (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    Q7UIPlugin.log((Throwable)e);
                }
            }
        }
    }

    public static class Remove
    extends WSAction {
        public Remove() {
            super("Remove", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length > 0);
        }

        public void run() {
            WSResource[] wSResourceArray = this.selection;
            int n = this.selection.length;
            int n2 = 0;
            while (n2 < n) {
                WSResource selectionItem = wSResourceArray[n2];
                this.removeContents(selectionItem);
                WSUtils.remove((WSResource)selectionItem);
                ++n2;
            }
        }

        private void removeContents(WSResource resource) {
            block5: {
                block4: {
                    if (!(resource instanceof WSFolder)) break block4;
                    WSFolder folder = (WSFolder)resource;
                    for (WSResource child : WSUtils.getContents((WSContainer)folder)) {
                        this.removeContents(child);
                    }
                    break block5;
                }
                if (!(resource instanceof WSFile)) break block5;
                WSFile file = (WSFile)resource;
                String name = ImportUtils.getName((WSFile)file);
                IPersistenceModel model = PersistenceManager.getInstance().getModel(this.getWorkspaceData().eResource());
                if (model != null) {
                    String[] names;
                    String[] stringArray = names = model.getNames();
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        if (f.startsWith(name)) {
                            model.delete(f);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public static class Rename
    extends WSAction {
        public Rename() {
            super("Rename", Images.getImageDescriptor((String)"icons/scenario_empty.gif"));
        }

        @Override
        protected void init() {
            this.setEnabled(this.selection != null && this.selection.length == 1 && (this.selection[0] instanceof WSFile || this.selection[0] instanceof WSFolder));
        }

        public void run() {
            this.viewer.editElement((Object)this.selection[0], 0);
        }
    }
}

