/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptorFactory;
import org.eclipse.equinox.weaving.hooks.WeavingBundleFile;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class WeavingAdaptor
implements IWeavingAdaptor {
    private static ThreadLocalSet identifyRecursionSet = new ThreadLocalSet();
    private Bundle bundle;
    private ICachingService cachingService;
    private final WeavingAdaptorFactory factory;
    private final BundleInfo.Generation generation;
    private boolean initialized = false;
    private final ModuleClassLoader moduleLoader;
    private final String symbolicName;
    private IWeavingService weavingService;

    public WeavingAdaptor(BundleInfo.Generation generation, WeavingAdaptorFactory serviceFactory, IWeavingService weavingService, ICachingService cachingService, ModuleClassLoader classLoader) {
        this.generation = generation;
        this.factory = serviceFactory;
        this.symbolicName = generation.getRevision().getSymbolicName();
        this.moduleLoader = classLoader;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- WeavingAdaptor.WeavingAdaptor() bundle=" + this.symbolicName);
        }
    }

    @Override
    public CacheEntry findClass(String name, URL sourceFileURL) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> WeavingAdaptor.findClass() bundle=" + this.symbolicName + ", url=" + String.valueOf(sourceFileURL) + ", name=" + name);
        }
        CacheEntry cacheEntry = null;
        this.initialize();
        if (this.cachingService != null) {
            cacheEntry = this.cachingService.findStoredClass("", sourceFileURL, name);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< WeavingAdaptor.findClass() cacheEntry=" + String.valueOf(cacheEntry));
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        WeavingAdaptor weavingAdaptor = this;
        synchronized (weavingAdaptor) {
            if (this.initialized) {
                return;
            }
            this.bundle = this.generation.getRevision().getBundle();
            if (!identifyRecursionSet.contains(this)) {
                identifyRecursionSet.put(this);
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("> WeavingAdaptor.initialize() bundle=" + this.symbolicName + ", moduleLoader=" + String.valueOf(this.moduleLoader));
                }
                if (this.symbolicName != null && this.symbolicName.startsWith("org.aspectj")) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- WeavingAdaptor.initialize() symbolicName=" + this.symbolicName + ", moduleLoader=" + String.valueOf(this.moduleLoader));
                    }
                } else if (this.moduleLoader != null) {
                    this.weavingService = this.factory.getWeavingService(this.moduleLoader);
                    this.cachingService = this.factory.getCachingService(this.moduleLoader, this.bundle, this.weavingService);
                } else if ((this.generation.getRevision().getTypes() & 1) != 0) {
                    BundleInfo.Generation hostGeneration;
                    BundleFile bundleFile;
                    Bundle host = this.factory.getHost(this.bundle);
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- WeavingAdaptor.initialize() symbolicName=" + this.symbolicName + ", host=" + String.valueOf(host));
                    }
                    if ((bundleFile = (hostGeneration = (BundleInfo.Generation)((ModuleRevision)host.adapt(BundleRevision.class)).getRevisionInfo()).getBundleFile()) instanceof WeavingBundleFile) {
                        WeavingBundleFile hostFile = (WeavingBundleFile)bundleFile;
                        WeavingAdaptor hostAdaptor = (WeavingAdaptor)hostFile.getAdaptor();
                        this.weavingService = hostAdaptor.weavingService;
                        this.cachingService = this.factory.getCachingService(hostAdaptor.moduleLoader, this.bundle, this.weavingService);
                    }
                } else if (Debug.DEBUG_GENERAL) {
                    Debug.println("W WeavingAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + String.valueOf(this.moduleLoader));
                }
                this.initialized = true;
                identifyRecursionSet.remove(this);
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("< WeavingAdaptor.initialize() weavingService=" + (this.weavingService != null) + ", cachingService=" + (this.cachingService != null));
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean storeClass(String name, URL sourceFileURL, Class<?> clazz, byte[] classbytes) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> WeavingAdaptor.storeClass() bundle=" + this.symbolicName + ", url=" + String.valueOf(sourceFileURL) + ", name=" + name + ", clazz=" + String.valueOf(clazz));
        }
        boolean stored = false;
        this.initialize();
        if (this.cachingService != null) {
            if (this.weavingService != null && this.weavingService.generatedClassesExistFor((ClassLoader)this.moduleLoader, name)) {
                if (this.cachingService.canCacheGeneratedClasses()) {
                    Map<String, byte[]> generatedClasses = this.weavingService.getGeneratedClassesFor(name);
                    stored = this.cachingService.storeClassAndGeneratedClasses("", sourceFileURL, clazz, classbytes, generatedClasses);
                } else {
                    this.weavingService.flushGeneratedClasses((ClassLoader)this.moduleLoader);
                    if (Debug.DEBUG_CACHE) {
                        Debug.println("- WeavingAdaptor.storeClass() generatedClassesExistFor=true");
                    }
                }
            } else {
                stored = this.cachingService.storeClass("", sourceFileURL, clazz, classbytes);
                if (!stored && Debug.DEBUG_CACHE) {
                    Debug.println("E WeavingAdaptor.storeClass() bundle=" + this.symbolicName + ", name=" + name);
                }
            }
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< WeavingAdaptor.storeClass() stored=" + stored);
        }
        return stored;
    }

    public String toString() {
        return "WeavingAdaptor[" + this.symbolicName + "]";
    }

    @Override
    public byte[] weaveClass(String name, byte[] bytes) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> WeavingAdaptor.weaveClass() bundle=" + this.symbolicName + ", name=" + name + ", bytes=" + bytes.length);
        }
        byte[] newBytes = null;
        this.initialize();
        if (this.weavingService != null) {
            try {
                newBytes = this.weavingService.preProcess(name, bytes, (ClassLoader)this.moduleLoader);
            }
            catch (IOException ex) {
                throw new ClassFormatError(ex.toString());
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< WeavingAdaptor.weaveClass() newBytes=" + String.valueOf(newBytes));
        }
        return newBytes;
    }

    private static class ThreadLocalSet
    extends ThreadLocal<Set<Object>> {
        private ThreadLocalSet() {
        }

        public boolean contains(Object obj) {
            Set set = (Set)this.get();
            return set.contains(obj);
        }

        @Override
        protected Set<Object> initialValue() {
            return new HashSet<Object>();
        }

        public void put(Object obj) {
            Set set = (Set)this.get();
            if (set.contains(obj)) {
                throw new RuntimeException(obj.toString());
            }
            set.add(obj);
        }

        public void remove(Object obj) {
            Set set = (Set)this.get();
            if (!set.contains(obj)) {
                throw new RuntimeException(obj.toString());
            }
            set.remove(obj);
        }
    }
}

