package aQute.maven.dto;

import java.net.URI;

import aQute.bnd.util.dto.DTO;

/**
 * This elements describes all that pertains to distribution for a project. It
 * is primarily used for deployment of artifacts and the site produced by the
 * build.
 */
public class DistributionManagementDTO extends DTO {
	/**
	 * Information needed to deploy the artifacts generated by the project to a
	 * remote repository.
	 */
	public DeploymentRepositoryDTO	deploymentRepository;

	/**
	 * Where to deploy snapshots of artifacts to. If not given, it defaults to
	 * the <code>repository</code> element.
	 */
	public DeploymentRepositoryDTO	snapshotRepository;

	/**
	 * Information needed for deploying the web site of the project.
	 */

	public SiteDTO					site;

	/**
	 * The URL of the project's download page. If not given users will be
	 * referred to the homepage given by <code>url</code>. This is given to
	 * assist in locating artifacts that are not in the repository due to
	 * licensing restrictions.
	 */
	public URI						downloadUrl;

	/**
	 * Relocation information of the artifact if it has been moved to a new
	 * group ID and/or artifact ID.
	 */

	public RelocationDTO			relocation;

	/**
	 * Gives the status of this artifact in the remote repository. This must not
	 * be set in your local project, as it is updated by tools placing it in the
	 * reposiory. Valid values are: <code>none</code> (default),
	 * <code>converted</code> (repository manager converted this from an Maven 1
	 * POM), <code>partner</code> (directly synced from a partner Maven 2
	 * repository), <code>deployed</code> (was deployed from a Maven 2
	 * instance), <code>verified</code> (has been hand verified as correct and
	 * final).
	 */

	public String					status;
}
