/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.operator.InputDecryptor;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Arrays;

public class JceInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JceInputDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public InputDecryptorProvider build(byte[] byArray) {
        final byte[] byArray2 = Arrays.clone((byte[])byArray);
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            @Override
            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                this.encryptionAlg = algorithmIdentifier;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                try {
                    this.cipher = JceInputDecryptorProviderBuilder.this.helper.createCipher(aSN1ObjectIdentifier.getId());
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, aSN1ObjectIdentifier.getId());
                    ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
                    if (aSN1Encodable instanceof ASN1OctetString) {
                        this.cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets()));
                    } else {
                        GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance((Object)aSN1Encodable);
                        this.cipher.init(2, (Key)secretKeySpec, (AlgorithmParameterSpec)new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
                    }
                }
                catch (Exception exception) {
                    throw new OperatorCreationException("unable to create InputDecryptor: " + exception.getMessage(), exception);
                }
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, cipher);
                    }
                };
            }
        };
    }
}

