/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.cache;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.internal.core.model.ModelInfo;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;
import org.eclipse.rcptt.internal.core.model.cache.ValueLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ModelCache {
    private static final int TIMEOUT_MS = 100000;
    private static final ILog LOG = Platform.getLog((Bundle)FrameworkUtil.getBundle(ModelCache.class));
    protected ModelInfo modelInfo;
    private final Cache<IQ7Element, Object> openableCache;
    private final ValueLock locks = new ValueLock();

    public ModelCache(long approxSizeInBytes) {
        RemovalListener<IQ7Element, Object> removalListener = new RemovalListener<IQ7Element, Object>(){

            public void onRemoval(RemovalNotification<IQ7Element, Object> notification) {
                Object value = notification.getValue();
                ModelCache.this.closeValue(value);
            }
        };
        Weigher weigher = (ignored, info) -> {
            if (info instanceof Q7ResourceInfo) {
                return ((Q7ResourceInfo)info).getCacheFootprint();
            }
            return 1000;
        };
        this.openableCache = CacheBuilder.newBuilder().weigher(weigher).maximumWeight(approxSizeInBytes).expireAfterAccess(10L, TimeUnit.MINUTES).removalListener((RemovalListener)removalListener).build();
    }

    public <T, V> V accessInfo(IQ7Element element, Class<T> clazz, Supplier<T> infoFactory, Function<T, V> infoToValue) throws InterruptedException {
        try {
            return (V)this.locks.exclusively(element, 100000, () -> {
                try {
                    Object[] result = new Object[1];
                    boolean[] found = new boolean[1];
                    Object info = clazz.cast(this.openableCache.get((Object)element, () -> this.lambda$2((Supplier)infoFactory, clazz, found, result, infoToValue)));
                    if (found[0]) {
                        return result[0];
                    }
                    return infoToValue.apply(info);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    Throwables.throwIfUnchecked((Throwable)cause);
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), InterruptedException.class);
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
    }

    public <T, V> Optional<V> peekInfo(IQ7Element element, Class<T> clazz, Function<T, V> infoToValue) {
        try {
            return this.locks.exclusively(element, 10, () -> Optional.ofNullable(this.openableCache.getIfPresent((Object)element)).map(clazz::cast).map(infoToValue));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (TimeoutException e) {
            return Optional.empty();
        }
    }

    public void removeInfo(IQ7Element element) throws InterruptedException {
        try {
            this.locks.exclusively(element, 100000, () -> {
                this.openableCache.invalidate((Object)element);
                return null;
            });
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private IStatus error(Exception e) {
        if (e instanceof CoreException) {
            return new MultiStatus(LOG.getBundle().getSymbolicName(), 0, new IStatus[]{((CoreException)((Object)e)).getStatus()}, e.getMessage(), (Throwable)e);
        }
        return new Status(4, LOG.getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e);
    }

    private void closeValue(Object value) {
        if (value instanceof Closeable) {
            try {
                ((Closeable)value).close();
            }
            catch (IOException e) {
                LOG.log(this.error(e));
            }
        }
    }

    private /* synthetic */ Object lambda$2(Supplier supplier, Class clazz, boolean[] blArray, Object[] objectArray, Function function) throws Exception {
        Object info3 = supplier.get();
        try {
            Object info2 = clazz.cast(info3);
            blArray[0] = true;
            objectArray[0] = function.apply(info2);
            return info2;
        }
        catch (Throwable e) {
            this.closeValue(info3);
            throw e;
        }
    }
}

