/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ui.describers;

import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.ui.describers.IDescriberExtension;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.rcptt.tesla.ui.describers.WidgetDescriber;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SWTDescriberExtension
implements IDescriberExtension {
    @Override
    public IWidgetDescriber getDescriber(Widget widget, IWidgetDescriber previous, int x, int y) {
        return this.getItemAt(new WidgetDescriber(widget), x, y);
    }

    private IWidgetDescriber getItemAt(IWidgetDescriber descr, int x, int y) {
        Rectangle bounds;
        int n;
        int n2;
        CoolItem[] coolItemArray;
        Widget base = descr.getWidget();
        if (base instanceof Tree) {
            Tree widget = (Tree)base;
            TreeItem item = null;
            TreeItem[] items = widget.getItems();
            item = this.findTreeItemAt(items, x, y);
            if (item != null) {
                return this.getDescriber((Widget)item);
            }
            return descr;
        }
        if (base instanceof Table) {
            Table widget = (Table)base;
            TableItem item = null;
            TableItem[] items = widget.getItems();
            item = this.findTableItemAt(items, x, y);
            if (item != null) {
                return this.getDescriber((Widget)item);
            }
            return descr;
        }
        if (base instanceof ToolBar) {
            ToolBar bar = (ToolBar)base;
            ToolItem item = bar.getItem(new Point(x, y));
            if (item != null) {
                return this.getDescriber((Widget)item);
            }
            return descr;
        }
        if (base instanceof CoolBar) {
            CoolBar bar = (CoolBar)base;
            CoolItem[] items = bar.getItems();
            Point pt = new Point(x, y);
            coolItemArray = items;
            n2 = items.length;
            n = 0;
            while (n < n2) {
                CoolItem coolItem = coolItemArray[n];
                bounds = coolItem.getBounds();
                if (bounds.contains(pt)) {
                    return this.getDescriber((Widget)coolItem);
                }
                ++n;
            }
        }
        if (base instanceof Composite) {
            Composite compo = (Composite)base;
            Control[] children = compo.getChildren();
            Point p = new Point(x, y);
            coolItemArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                CoolItem control = coolItemArray[n];
                if (control.isVisible() && (bounds = control.getBounds()).contains(p)) {
                    return this.getItemAt(this.getDescriber((Widget)control), x - bounds.x, y - bounds.y);
                }
                ++n;
            }
        }
        return descr;
    }

    private IWidgetDescriber getDescriber(Widget item) {
        return new WidgetDescriber(item);
    }

    private TreeItem findTreeItemAt(TreeItem[] items, int x, int y) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem itemAt;
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getBounds().contains(x, y)) {
                return treeItem;
            }
            TreeItem[] treeItems = treeItem.getItems();
            if (treeItems != null && treeItems.length > 0 && (itemAt = this.findTreeItemAt(treeItems, x, y)) != null) {
                return itemAt;
            }
            ++n2;
        }
        return null;
    }

    private TableItem findTableItemAt(TableItem[] items, int x, int y) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem treeItem = tableItemArray[n2];
            if (treeItem.getBounds().contains(x, y)) {
                return treeItem;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IWidgetDescriber getDescriber(Element element, AbstractTeslaClient client) {
        SWTUIProcessor processor = (SWTUIProcessor)client.getProcessor(SWTUIProcessor.class);
        SWTUIElement swtuiElement = (SWTUIElement)processor.getMapper().get(element);
        if (swtuiElement != null) {
            return new WidgetDescriber(PlayerWrapUtils.unwrapWidget(swtuiElement));
        }
        return null;
    }
}

