/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.LambdaExpressionsFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class LambdaExpressionsCleanUpCore
extends AbstractCleanUp {
    public LambdaExpressionsCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public LambdaExpressionsCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        boolean convertFunctionalInterfaces = this.isEnabled("cleanup.convert_functional_interfaces");
        if (!convertFunctionalInterfaces) {
            return false;
        }
        return this.isEnabled("cleanup.use_lambda") || this.isEnabled("cleanup.use_anonymous_class_creation");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean convertFunctionalInterfaces = this.isEnabled("cleanup.convert_functional_interfaces");
        if (!convertFunctionalInterfaces) {
            return null;
        }
        return LambdaExpressionsFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.use_lambda"), this.isEnabled("cleanup.use_anonymous_class_creation"), this.isEnabled("cleanup.simplify_lambda_expression_and_method_ref") || this.isEnabled("cleanup.use_lambda") && this.isEnabled("cleanup.also_simplify_lambda"));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.convert_functional_interfaces")) {
            if (this.isEnabled("cleanup.use_lambda")) {
                if (this.isEnabled("cleanup.also_simplify_lambda")) {
                    result.add(MultiFixMessages.LambdaExpressionsCleanUp_use_lambda_and_simplify);
                } else {
                    result.add(MultiFixMessages.LambdaExpressionsCleanUp_use_lambda_where_possible);
                }
            }
            if (this.isEnabled("cleanup.use_anonymous_class_creation")) {
                result.add(MultiFixMessages.LambdaExpressionsCleanUp_use_anonymous);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        boolean secondLambda;
        StringBuilder buf = new StringBuilder();
        boolean convert = this.isEnabled("cleanup.convert_functional_interfaces");
        boolean useLambda = this.isEnabled("cleanup.use_lambda");
        boolean useAnonymous = this.isEnabled("cleanup.use_anonymous_class_creation");
        boolean simplifyLambda = this.isEnabled("cleanup.also_simplify_lambda");
        boolean firstLambda = convert && useLambda;
        boolean bl = secondLambda = !convert || !useAnonymous;
        if (firstLambda) {
            if (simplifyLambda) {
                buf.append("IntConsumer c = System.out::println;\n");
                buf.append("\n");
                buf.append("\n");
                buf.append("\n");
                buf.append("\n");
            } else {
                buf.append("IntConsumer c = i -> {\n");
                buf.append("    System.out.println(i);\n");
                buf.append("};\n");
                buf.append("\n");
                buf.append("\n");
            }
        } else {
            buf.append("IntConsumer c = new IntConsumer() {\n");
            buf.append("    @Override public void accept(int value) {\n");
            buf.append("        System.out.println(i);\n");
            buf.append("    }\n");
            buf.append("};\n");
        }
        if (secondLambda) {
            buf.append("Runnable r = () -> { /* do something */ };\n");
            buf.append("\n");
            buf.append("\n");
            buf.append("\n");
            buf.append("\n");
        } else {
            buf.append("Runnable r = new Runnable() {\n");
            buf.append("    @Override public void run() {\n");
            buf.append("        //do something\n");
            buf.append("    }\n");
            buf.append("};\n");
        }
        return buf.toString();
    }
}

