/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartReference;

public class PlayerWidgetUtils {
    public static boolean isVisible(Control control) {
        if (control == null) {
            return false;
        }
        return control.isVisible();
    }

    public static boolean canClick(SWTUIElement w) {
        if (PlayerWrapUtils.unwrap(w) instanceof IWorkbenchPartReference) {
            return PlayerWidgetUtils.canClickView(w);
        }
        boolean visible = true;
        Widget control = PlayerWrapUtils.unwrapWidget(w);
        if (control instanceof Control) {
            boolean bl = visible = !control.isDisposed() && PlayerWidgetUtils.isVisible((Control)control);
        }
        return !PlayerWidgetUtils.isDisabled(w) && visible;
    }

    public static boolean canClickView(SWTUIElement w) {
        if (w instanceof WorkbenchUIElement) {
            IWorkbenchPartReference reference = ((WorkbenchUIElement)w).getReference();
            return EclipseWorkbenchProvider.getProvider().canClickView(reference);
        }
        return true;
    }

    public static boolean isDisabled(SWTUIElement uiElement) {
        Widget w = PlayerWrapUtils.unwrapWidget(uiElement);
        boolean result = false;
        if (w != null && w instanceof Control && !w.isDisposed()) {
            result = !((Control)w).isEnabled();
        } else if (w != null && w instanceof MenuItem) {
            result = !((MenuItem)w).isEnabled();
        } else if (w != null && w instanceof ToolItem) {
            result = !((ToolItem)w).isEnabled();
        }
        return result;
    }

    public static Shell getModalChild(SWTUIElement control) {
        Widget w = PlayerWrapUtils.unwrapWidget(control);
        if (w == null) {
            return null;
        }
        if (w.isDisposed()) {
            return null;
        }
        if (w instanceof ToolItem) {
            w = ((ToolItem)w).getParent();
        } else if (w instanceof MenuItem) {
            w = ((MenuItem)w).getParent();
        } else if (w instanceof TreeItem) {
            w = ((TreeItem)w).getParent();
        } else if (w instanceof TableItem) {
            w = ((TableItem)w).getParent();
        } else if (w instanceof CoolItem) {
            w = ((CoolItem)w).getParent();
        } else if (w instanceof CTabItem) {
            w = ((CTabItem)w).getParent();
        } else if (w instanceof ExpandItem) {
            w = ((ExpandItem)w).getParent();
        }
        if (w instanceof Control) {
            Shell[] shells;
            Shell shell = ((Control)w).getShell();
            Shell[] shellArray = shells = shell.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell2 = shellArray[n2];
                if (PlayerWidgetUtils.isModal(shell2)) {
                    return shell2;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isModal(Shell shell) {
        if (!shell.isVisible()) {
            return false;
        }
        int style = shell.getStyle();
        int mask = 229376;
        String text = shell.getText();
        if (text != null && (text.trim().equalsIgnoreCase("problem occurred") || text.trim().equalsIgnoreCase("Operation failed"))) {
            return true;
        }
        return (style & mask) > 0;
    }
}

