/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.OneProjectScope;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.ui.commons.ColumnViewerSorter;
import org.eclipse.rcptt.ui.controls.TestSuiteButtonsPanel;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ScenariosLaunchTab
extends AbstractLaunchConfigurationTab {
    private static final String NOTHING_SELECTED = "";
    private TableViewer viewer;
    private ComboViewer autCombo;
    private final List<ITableElement> elements = new ArrayList<ITableElement>();
    TestSuiteButtonsPanel testSuiteButtonsPanel;
    private final WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        composite.setLayout((Layout)topLayout);
        this.createSuitTable(composite);
        this.createPanel(composite);
        this.validatePage();
    }

    private void createSuitTable(Composite parent) {
        this.viewer = new TableViewer(parent, 67586);
        GridData tableGridData = new GridData(1808);
        tableGridData.widthHint = 1;
        this.viewer.getTable().setLayoutData((Object)tableGridData);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.createTableColumns();
    }

    private void createTableColumns() {
        final TableViewerColumn columnTestCase = new TableViewerColumn(this.viewer, 0);
        columnTestCase.getColumn().setText(Messages.ScenariosLaunchTab_ColumnTestCaseText);
        columnTestCase.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return ((NamedTableElement)element).getImage();
            }

            public String getText(Object element) {
                return ((NamedTableElement)element).getText();
            }
        });
        final TableViewerColumn columnLocation = new TableViewerColumn(this.viewer, 0);
        columnLocation.getColumn().setText(Messages.ScenariosLaunchTab_ColumnLocationText);
        columnLocation.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((NamedTableElement)element).getPath();
            }
        });
        this.viewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = ScenariosLaunchTab.this.viewer.getTable().getClientArea().width;
                int testCaseColWidth = columnTestCase.getColumn().getWidth();
                int locationColWidth = columnLocation.getColumn().getWidth();
                double ratio = 0.5;
                if (testCaseColWidth != 0 && locationColWidth != 0) {
                    ratio = (double)testCaseColWidth / (double)(testCaseColWidth + locationColWidth);
                }
                columnTestCase.getColumn().setWidth((int)((double)width * ratio));
                columnLocation.getColumn().setWidth((int)((double)width * (1.0 - ratio)));
            }
        });
        new ColumnViewerSorter((ColumnViewer)this.viewer, columnTestCase){

            @Override
            protected int doCompare(Viewer viewer, Object element1, Object element2) {
                NamedTableElement named1 = (NamedTableElement)element1;
                NamedTableElement named2 = (NamedTableElement)element2;
                return named1.getText().compareToIgnoreCase(named2.getText());
            }

            @Override
            protected void afterSort() {
                ScenariosLaunchTab.this.reorderSourceList();
            }
        };
        new ColumnViewerSorter((ColumnViewer)this.viewer, columnLocation){

            @Override
            protected int doCompare(Viewer viewer, Object element1, Object element2) {
                NamedTableElement named1 = (NamedTableElement)element1;
                NamedTableElement named2 = (NamedTableElement)element2;
                return named1.getPath().compareToIgnoreCase(named2.getPath());
            }

            @Override
            protected void afterSort() {
                ScenariosLaunchTab.this.reorderSourceList();
            }
        };
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScenariosLaunchTab.this.testSuiteButtonsPanel.updateButtons(ScenariosLaunchTab.this.viewer);
            }
        });
    }

    private void createPanel(Composite parent) {
        this.testSuiteButtonsPanel = new TestSuiteButtonsPanel(parent, false);
        this.testSuiteButtonsPanel.getAddTestCaseBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.addTestCase();
            }
        });
        this.testSuiteButtonsPanel.getAddFolderBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.addFolder();
            }
        });
        this.testSuiteButtonsPanel.getRemoveBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.removeSelected();
            }
        });
        this.testSuiteButtonsPanel.getRemoveAllBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.removeAll();
            }
        });
        this.testSuiteButtonsPanel.getMoveUpBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.moveUp();
            }
        });
        this.testSuiteButtonsPanel.getMoveDownBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.moveDown();
            }
        });
        this.testSuiteButtonsPanel.getAddTaggedBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenariosLaunchTab.this.addTagged();
            }
        });
        new Label((Composite)this.testSuiteButtonsPanel, 258);
        Label label = new Label((Composite)this.testSuiteButtonsPanel, 1024);
        label.setText("AUT:");
        this.autCombo = this.createAutCombo(this.testSuiteButtonsPanel);
    }

    private ComboViewer createAutCombo(Composite parent) {
        ComboViewer autCombo = new ComboViewer(parent);
        autCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        autCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Aut) {
                    return ((Aut)element).getName();
                }
                return super.getText(element);
            }
        });
        autCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScenariosLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        autCombo.setInput((Object)Iterables.toArray((Iterable)Iterables.concat(Arrays.asList(NOTHING_SELECTED), (Iterable)AutManager.INSTANCE.getAuts()), Object.class));
        return autCombo;
    }

    private void addTestCase() {
        ArrayList<IQ7NamedElement> excluded = new ArrayList<IQ7NamedElement>();
        for (ITableElement element : this.elements) {
            excluded.add(element.getElement());
        }
        IQ7NamedElement[] selected = TestSuiteButtonsPanel.selectTestCase((ISearchScope)new AllProjectScope(), excluded, true);
        int i = 0;
        while (i < selected.length) {
            this.elements.add(new NamedTableElement(selected[i]));
            ++i;
        }
        this.sourceListChanged();
    }

    private void addFolder() {
        IContainer container = TestSuiteButtonsPanel.selectFolder();
        if (container != null) {
            IPath fullPath = container.getFullPath();
            IQ7NamedElement[] allElements = Q7SearchCore.findAllElements((ISearchScope)new OneProjectScope(RcpttCore.create((IProject)container.getProject())));
            int i = 0;
            while (i < allElements.length) {
                IQ7NamedElement el = allElements[i];
                if (el instanceof ITestCase && fullPath.isPrefixOf(el.getPath()) && !this.isElementInList(el)) {
                    this.elements.add(new NamedTableElement(el));
                }
                ++i;
            }
        }
        this.sourceListChanged();
    }

    private void addTagged() {
        ArrayList<IQ7NamedElement> excluded = new ArrayList<IQ7NamedElement>();
        for (ITableElement element : this.elements) {
            excluded.add(element.getElement());
        }
        IQ7NamedElement[] filteredByTags = TestSuiteButtonsPanel.selectTags((ISearchScope)new AllProjectScope(), excluded, true);
        int i = 0;
        while (i < filteredByTags.length) {
            this.elements.add(new NamedTableElement(filteredByTags[i]));
            ++i;
        }
        this.sourceListChanged();
    }

    private void removeSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        List selectedElements = selection.toList();
        this.elements.removeAll(selectedElements);
        this.sourceListChanged();
    }

    private void removeAll() {
        this.elements.clear();
        this.sourceListChanged();
    }

    private void moveUp() {
        this.resetTableSort();
        Table table = this.viewer.getTable();
        int[] indices = table.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.swapElements(index, index - 1);
                newSelection[i] = index - 1;
            } else if (index == 0) {
                newSelection[i] = 0;
            }
            ++i;
        }
        this.sourceListChanged();
        table.setSelection(newSelection);
        this.testSuiteButtonsPanel.updateButtons(this.viewer);
    }

    private void moveDown() {
        this.resetTableSort();
        Table table = this.viewer.getTable();
        int[] indices = table.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = table.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.swapElements(index, index + 1);
                newSelection[i] = index + 1;
            } else if (index == max) {
                newSelection[i] = max;
            }
            --i;
        }
        this.sourceListChanged();
        table.setSelection(newSelection);
        this.testSuiteButtonsPanel.updateButtons(this.viewer);
    }

    private void swapElements(int a, int b) {
        ITableElement aElement = this.elements.get(a);
        ITableElement bElement = this.elements.get(b);
        this.elements.set(a, bElement);
        this.elements.set(b, aElement);
    }

    private void resetTableSort() {
        this.viewer.getTable().setSortColumn(null);
        this.viewer.getTable().setSortDirection(0);
        this.viewer.setSorter(null);
    }

    private void sourceListChanged() {
        this.viewer.refresh();
        this.validatePage();
        this.updateLaunchConfigurationDialog();
        this.testSuiteButtonsPanel.updateButtons(this.viewer);
    }

    private void reorderSourceList() {
        this.elements.clear();
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            this.elements.add((ITableElement)this.viewer.getElementAt(i));
            ++i;
        }
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private boolean isElementInList(IQ7NamedElement namedElement) {
        if (namedElement == null) {
            return true;
        }
        for (ITableElement element : this.elements) {
            if (!element.getElement().equals(namedElement)) continue;
            return true;
        }
        return false;
    }

    private void buildElements(IResource[] resources) {
        this.elements.clear();
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource != null && resource.exists()) {
                    try {
                        ITableElement element = this.buildElement(resource);
                        if (element != null) {
                            this.elements.add(element);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        this.viewer.setInput(this.elements);
        this.testSuiteButtonsPanel.updateButtons(this.viewer);
    }

    private ITableElement buildElement(IResource res) {
        try {
            IFile file;
            IQ7Element element;
            if (res instanceof IFile && (element = RcpttCore.create((IResource)(file = (IFile)res))) != null && element instanceof IQ7NamedElement) {
                return new NamedTableElement((IQ7NamedElement)element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        IResource[] resources = null;
        Aut aut = null;
        try {
            int resourceCount = config.getAttribute("q7.exec.resources", -1);
            resources = config.getMappedResources();
            if (resourceCount > 0) {
                IResource[] subarray = new IResource[resourceCount];
                System.arraycopy(resources, 0, subarray, 0, Math.min(resourceCount, resources.length));
                resources = subarray;
            }
            String autName = config.getAttribute("org.eclipse.rcptt.launching.BOUND_AUT_NAME_ATTR", NOTHING_SELECTED);
            aut = AutManager.INSTANCE.getByName(autName);
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log((Throwable)e);
        }
        this.buildElements(resources);
        this.setSelectedAut(aut);
        this.validatePage();
    }

    private void setSelectedAut(Aut aut) {
        Object toSelect = aut;
        if (toSelect == null) {
            toSelect = NOTHING_SELECTED;
        }
        this.autCombo.setSelection((ISelection)new StructuredSelection(toSelect));
    }

    private Aut getSelectedAut() {
        if (this.autCombo == null) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)this.autCombo.getSelection();
        Object selected = selection.getFirstElement();
        if (selected instanceof Aut) {
            return (Aut)selected;
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (ITableElement element : this.elements) {
            resources.add(element.getResource());
        }
        config.setMappedResources(resources.toArray(new IResource[resources.size()]));
        config.setAttribute("q7.exec.resources", resources.size());
        config.setAttribute("org.eclipse.rcptt.launching.NO_SORT", true);
        Aut aut = this.getSelectedAut();
        config.setAttribute("org.eclipse.rcptt.launching.BOUND_AUT_NAME_ATTR", aut == null ? null : aut.getName());
    }

    public Image getImage() {
        return Images.getImage("icons/context.gif");
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.validatePage();
        return this.getErrorMessage() == null;
    }

    private void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.viewer.getTable().getItemCount() == 0) {
            this.setErrorMessage(Messages.ScenariosLaunchTab_NothingSelectedMsg);
            return;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IResource[] resources = LaunchUtils.getContext();
        IQ7NamedElement[] elements = TestSuiteUtils.getElements((IResource[])resources, (boolean)false);
        String name = Q7Launcher.getLaunchName((IQ7NamedElement[])elements);
        config.setMappedResources(resources);
        this.initializeName(config, name);
        config.setAttribute("org.eclipse.rcptt.launching.NO_SORT", true);
        config.setAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", NOTHING_SELECTED);
    }

    private void initializeName(ILaunchConfigurationWorkingCopy config, String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(index + 1);
        }
        name = this.getLaunchConfigurationDialog().generateName(name);
        config.rename(name);
    }

    public String getName() {
        return Messages.ScenariosLaunchTab_Name;
    }

    public String getId() {
        return "org.eclipse.rcptt.ui.launching.ScenariosLaunchTab";
    }

    public void dispose() {
        super.dispose();
        this.wbLabelProvider.dispose();
    }

    private static interface ITableElement {
        public static final ITableElement[] EMPTY = new ITableElement[0];

        public IResource getResource();

        public IQ7NamedElement getElement();

        public Image getImage();

        public String getText();

        public String getPath();
    }

    private class NamedTableElement
    implements ITableElement {
        private final IQ7NamedElement element;

        public NamedTableElement(IQ7NamedElement element) {
            this.element = element;
        }

        @Override
        public IResource getResource() {
            return this.element.getResource();
        }

        @Override
        public IQ7NamedElement getElement() {
            return this.element;
        }

        @Override
        public Image getImage() {
            return ModelUtils.getImage((IQ7Element)this.element);
        }

        @Override
        public String getText() {
            return ModelUtils.getText((IQ7Element)this.element);
        }

        @Override
        public String getPath() {
            return String.valueOf(this.getResource().getProject().getName()) + "/" + this.getResource().getProjectRelativePath().removeLastSegments(1).toString();
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return ITableElement.EMPTY;
        }
    }
}

