/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist.display;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jface.internal.text.html.SingleCharReader;

public class JavaDocCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private final int fStartPos;
    private final int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.fBuffer.getChar(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            ch = this.fBuffer.getChar(this.fCurrPos++);
        }
        this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)ch);
        return ch;
    }

    public void close() {
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

