/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.resources.EclipseProjectFactory;
import org.eclipse.oomph.resources.ProjectHandler;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.impl.SourceLocatorImpl;
import org.eclipse.oomph.targlets.IUGenerator;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.util.VersionGenerator;
import org.eclipse.oomph.util.OomphPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceIUAnalyzer {
    public static final String IU_PROPERTY_WORKSPACE = "org.eclipse.oomph.targlet.workspace";
    public static final String IU_PROPERTY_WORKSPACE_MAIN = "org.eclipse.oomph.targlet.workspace.main";
    private final MultiStatus status = new MultiStatus(TargletsCorePlugin.INSTANCE.getSymbolicName(), 0, "Workspace IU Analysis", null);
    private final Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = Collections.synchronizedMap(new HashMap());
    private final Map<String, Version> iuVersions = Collections.synchronizedMap(new HashMap());
    private final String qualifierReplacement;

    public WorkspaceIUAnalyzer() {
        this(VersionGenerator.generateQualifierReplacement());
    }

    public WorkspaceIUAnalyzer(String qualifierReplacement) {
        this.qualifierReplacement = qualifierReplacement;
    }

    public Map<IInstallableUnit, WorkspaceIUInfo> getWorkspaceIUInfos() {
        return this.workspaceIUInfos;
    }

    public Map<String, Version> getIUVersions() {
        return this.iuVersions;
    }

    public String getQualifierReplacement() {
        return this.qualifierReplacement;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public EList<IInstallableUnit> analyze(SourceLocator sourceLocator, final EList<IUGenerator> generators, IProgressMonitor monitor) {
        final EList allIUs = ECollections.asEList(Collections.synchronizedList(new ArrayList()));
        sourceLocator.handleProjects(EclipseProjectFactory.LIST, new ProjectHandler(){

            public void handleProject(IProject project, BackendContainer backendContainer) {
                try {
                    BasicEList ius = new BasicEList();
                    for (IUGenerator generator : generators) {
                        try {
                            generator.generateIUs(project, WorkspaceIUAnalyzer.this.qualifierReplacement, WorkspaceIUAnalyzer.this.iuVersions, (EList)ius);
                        }
                        catch (Exception ex) {
                            WorkspaceIUAnalyzer.this.log(project, ex);
                        }
                    }
                    WorkspaceIUInfo info = new WorkspaceIUInfo(backendContainer, project.getName());
                    boolean isMain = true;
                    for (IInstallableUnit iu : ius) {
                        if (iu instanceof InstallableUnit) {
                            InstallableUnit installableUnit = (InstallableUnit)iu;
                            installableUnit.setProperty(WorkspaceIUAnalyzer.IU_PROPERTY_WORKSPACE, Boolean.TRUE.toString());
                            if (isMain) {
                                isMain = false;
                                installableUnit.setProperty(WorkspaceIUAnalyzer.IU_PROPERTY_WORKSPACE_MAIN, Boolean.TRUE.toString());
                            }
                        }
                        WorkspaceIUAnalyzer.this.workspaceIUInfos.put(iu, info);
                    }
                    allIUs.addAll((Collection)ius);
                }
                catch (Exception ex) {
                    WorkspaceIUAnalyzer.this.log(project, ex);
                }
            }
        }, this.status, monitor);
        return allIUs;
    }

    public void adjustOmniRootRequirements(EList<Requirement> rootRequirements) {
        if (this.qualifierReplacement != null) {
            HashMap<String, Requirement> omniRootRequirements = new HashMap<String, Requirement>();
            for (Requirement requirement : rootRequirements) {
                if (!VersionRange.emptyRange.equals((Object)requirement.getVersionRange())) continue;
                omniRootRequirements.put(requirement.getName(), requirement);
            }
            for (IInstallableUnit iu : this.workspaceIUInfos.keySet()) {
                Requirement requirement;
                if (iu.isSingleton() || "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.group")) || (requirement = (Requirement)omniRootRequirements.remove(iu.getId())) == null) continue;
                requirement.setVersionRange(P2Factory.eINSTANCE.createVersionRange(iu.getVersion(), VersionSegment.MICRO));
                if (!omniRootRequirements.isEmpty()) continue;
                return;
            }
        }
    }

    protected void log(IProject project, Exception ex) {
        SourceLocatorImpl.addStatus((MultiStatus)this.status, (OomphPlugin)TargletsCorePlugin.INSTANCE, (String)("project " + project.getName()), (Object)ex);
    }
}

