/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.p2.internal.core.DownloadArtifactEvent;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OfflineMode;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;

public class CachingTransport
extends Transport {
    public static final String SERVICE_NAME = Transport.SERVICE_NAME;
    private static final ThreadLocal<Stack<String>> REPOSITORY_LOCATIONS = new InheritableThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    private static final Map<java.net.URI, Object> URI_LOCKS = new HashMap<java.net.URI, Object>();
    private static boolean DEBUG = false;
    private final IProvisioningAgent agent;
    private IProvisioningEventBus eventBus;
    private final File cacheFolder;
    private Transport delegate;

    public CachingTransport(Transport delegate, IProvisioningAgent agent) {
        this.setDelegate(delegate);
        this.agent = agent;
        this.eventBus = (IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME);
        File folder = P2CorePlugin.getUserStateFolder(new File(PropertiesUtil.getUserHome()));
        this.cacheFolder = new File(folder, "cache");
        this.cacheFolder.mkdirs();
    }

    public final Transport getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(Transport delegate) {
        if (delegate instanceof CachingTransport) {
            throw new IllegalArgumentException("CachingTransport should not be chained");
        }
        this.delegate = delegate;
    }

    public File getCacheFile(java.net.URI uri) {
        return new File(this.cacheFolder, IOUtil.encodeFileName((String)uri.toString()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IStatus download(java.net.URI uri, OutputStream target, long startPos, IProgressMonitor monitor) {
        if (DEBUG) {
            CachingTransport.log("  ! " + uri);
        }
        if (!CachingTransport.isLoadingRepository(uri)) {
            if ("bogus".equals(uri.getScheme())) {
                IOException ex = new IOException("Repeated attemps to download " + uri.getRawSchemeSpecificPart() + " from the same site");
                ex.fillInStackTrace();
                return P2CorePlugin.INSTANCE.getStatus(ex);
            }
            IStatus status = Status.CANCEL_STATUS;
            try {
                if (this.eventBus != null) {
                    this.eventBus.publishEvent((EventObject)new DownloadArtifactEvent(uri));
                }
                IStatus iStatus = status = this.delegate.download(uri, target, startPos, monitor);
                return iStatus;
            }
            finally {
                if (this.eventBus != null) {
                    this.eventBus.publishEvent((EventObject)new DownloadArtifactEvent(uri, status));
                }
            }
        }
        Object object = this.getLock(uri);
        synchronized (object) {
            IStatus iStatus;
            File cacheFile = this.getCacheFile(uri);
            if (cacheFile.length() > 0L) {
                IStatus iStatus2;
                FileInputStream cacheInputStream = null;
                try {
                    cacheInputStream = new FileInputStream(cacheFile);
                    IOUtil.copy((InputStream)cacheInputStream, (OutputStream)target);
                    this.removeLock(uri);
                    iStatus2 = Status.OK_STATUS;
                }
                catch (Exception exception) {
                    try {}
                    catch (Throwable throwable) {
                        IOUtil.closeSilent(cacheInputStream);
                        throw throwable;
                    }
                    IOUtil.closeSilent((Closeable)cacheInputStream);
                }
                IOUtil.closeSilent((Closeable)cacheInputStream);
                return iStatus2;
            }
            StatefulFileOutputStream statefulTarget = null;
            FileInputStream cacheInputStream = null;
            try {
                cacheFile.getParentFile().mkdirs();
                File tempCacheFile = new File(String.valueOf(cacheFile.getPath()) + ".downloading");
                try {
                    statefulTarget = new StatefulFileOutputStream(tempCacheFile);
                }
                catch (IOException iOException) {}
                IStatus status = this.delegate.download(uri, statefulTarget != null ? statefulTarget : target, startPos, monitor);
                if (statefulTarget != null) {
                    IOUtil.closeSilent((Closeable)statefulTarget);
                    if (status.isOK()) {
                        String path;
                        cacheFile.delete();
                        tempCacheFile.renameTo(cacheFile);
                        cacheInputStream = new FileInputStream(cacheFile);
                        IOUtil.copy((InputStream)cacheInputStream, (OutputStream)target);
                        DownloadStatus downloadStatus = (DownloadStatus)status;
                        long lastModified = downloadStatus.getLastModified();
                        if (lastModified >= 0L) {
                            cacheFile.setLastModified(lastModified);
                        }
                        if ((path = cacheFile.getPath()).endsWith(".xml")) {
                            new File(String.valueOf(path.substring(0, path.length() - 4)) + ".jar").delete();
                        } else if (path.endsWith(".jar")) {
                            new File(String.valueOf(path.substring(0, path.length() - 4)) + ".xml").delete();
                        }
                    } else {
                        IOUtil.deleteBestEffort((File)tempCacheFile);
                    }
                }
                iStatus = status;
            }
            catch (IOException ex) {
                try {
                    throw new IORuntimeException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (target instanceof IStateful && statefulTarget != null) {
                        ((IStateful)target).setStatus(statefulTarget.getStatus());
                    }
                    IOUtil.closeSilent(cacheInputStream);
                    IOUtil.closeSilent(statefulTarget);
                    this.removeLock(uri);
                    throw throwable;
                }
            }
            if (target instanceof IStateful && statefulTarget != null) {
                ((IStateful)target).setStatus(statefulTarget.getStatus());
            }
            IOUtil.closeSilent(cacheInputStream);
            IOUtil.closeSilent((Closeable)statefulTarget);
            this.removeLock(uri);
            return iStatus;
        }
    }

    public IStatus download(java.net.URI uri, OutputStream target, IProgressMonitor monitor) {
        return this.download(uri, target, -1L, monitor);
    }

    public InputStream stream(java.net.URI uri, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        return this.delegate.stream(uri, monitor);
    }

    public long getLastModified(java.net.URI uri, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        if (DEBUG) {
            CachingTransport.log("  ? " + uri);
        }
        if (CachingTransport.isLoadingRepository(uri) && OfflineMode.isEnabled()) {
            File cacheFile = this.getCacheFile(uri);
            if (cacheFile.length() > 0L) {
                return cacheFile.lastModified();
            }
            CacheManager cacheManager = (CacheManager)this.agent.getService(CacheManager.SERVICE_NAME);
            if (cacheManager == null) {
                throw new IllegalArgumentException("Cache manager service not available");
            }
            URI location = URI.createURI((String)uri.toString());
            String fileExtension = location.fileExtension();
            if ("xz".equals(fileExtension)) {
                Method method = ReflectUtil.getMethod((Object)cacheManager, (String)"getCacheFile", (Class[])new Class[]{java.net.URI.class});
                File file = (File)ReflectUtil.invokeMethod((Method)method, (Object)cacheManager, (Object[])new Object[]{uri});
                if (file != null && file.exists()) {
                    return file.lastModified();
                }
            } else {
                String prefix = location.trimFileExtension().lastSegment();
                try {
                    URI repositoryLocation = location.trimSegments(1);
                    java.net.URI repositoryURI = new java.net.URI(repositoryLocation.toString());
                    Method method = ReflectUtil.getMethod((Object)cacheManager, (String)"getCache", (Class[])new Class[]{java.net.URI.class, String.class});
                    File file = (File)ReflectUtil.invokeMethod((Method)method, (Object)cacheManager, (Object[])new Object[]{repositoryURI, prefix});
                    if (file != null && file.exists()) {
                        if (!file.toString().endsWith(fileExtension)) {
                            throw new FileNotFoundException("We're offline and there is a cached version, but with a different extension, so fail now and use that one.");
                        }
                        return file.lastModified();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            try {
                return this.delegateGetLastModified(uri, monitor);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                FileNotFoundException exception = new FileNotFoundException(ex.getMessage());
                exception.initCause(ex);
                throw exception;
            }
        }
        try {
            return this.delegateGetLastModified(uri, monitor);
        }
        catch (CoreException exception) {
            IStatus status;
            Throwable statusException;
            File cacheFile = this.getCacheFile(uri);
            if (cacheFile.length() > 0L && this.confirmCacheUsage(uri, cacheFile)) {
                return cacheFile.lastModified();
            }
            if (uri.toString().endsWith(".jar") && (statusException = (status = exception.getStatus()).getException()) instanceof SocketTimeoutException) {
                IOExceptionWithCause wrappedException = new IOExceptionWithCause(statusException);
                ReflectUtil.setValue((String)"exception", (Object)status, (Object)wrappedException);
            }
            throw exception;
        }
        catch (FileNotFoundException exception) {
            throw exception;
        }
        catch (AuthenticationFailedException exception) {
            File cacheFile = this.getCacheFile(uri);
            if (cacheFile.length() > 0L && this.confirmCacheUsage(uri, cacheFile)) {
                return cacheFile.lastModified();
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long delegateGetLastModified(java.net.URI uri, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        long lastModified = this.delegate.getLastModified(uri, monitor);
        File cacheFile = this.getCacheFile(uri);
        if (cacheFile.length() == 0L) {
            return lastModified - 1L;
        }
        if (cacheFile.lastModified() != lastModified || lastModified == 0L) {
            Object object = this.getLock(uri);
            synchronized (object) {
                cacheFile.delete();
            }
            return lastModified - 1L;
        }
        return lastModified;
    }

    private synchronized boolean confirmCacheUsage(java.net.URI uri, File file) {
        CacheUsageConfirmer cacheUsageConfirmer = (CacheUsageConfirmer)this.agent.getService(CacheUsageConfirmer.SERVICE_NAME);
        if (cacheUsageConfirmer != null) {
            return cacheUsageConfirmer.confirmCacheUsage(uri, file);
        }
        return false;
    }

    private synchronized Object getLock(java.net.URI uri) {
        Object result = URI_LOCKS.get(uri);
        if (result == null) {
            result = new Object();
            URI_LOCKS.put(uri, result);
        }
        return result;
    }

    private synchronized void removeLock(java.net.URI uri) {
        URI_LOCKS.remove(uri);
    }

    private static boolean isLoadingRepository(java.net.URI uri) {
        Stack<String> stack;
        String location = URI.createURI((String)uri.toString()).trimSegments(1).toString();
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        return !(stack = REPOSITORY_LOCATIONS.get()).isEmpty() && stack.peek().equals(location);
    }

    private static void log(String message) {
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        int i = 1;
        while (i < stack.size()) {
            message = "   " + message;
            ++i;
        }
        System.out.println(message);
    }

    static void startLoadingRepository(java.net.URI location) {
        String uri = location.toString();
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        stack.push(uri);
        if (DEBUG && !uri.startsWith("file:")) {
            CachingTransport.log("--> " + location);
        }
    }

    static void stopLoadingRepository() {
        String location;
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        if (DEBUG && !stack.isEmpty() && !(location = stack.peek()).startsWith("file:")) {
            CachingTransport.log("<-- " + location);
        }
        stack.pop();
    }

    private static final class StatefulFileOutputStream
    extends FileOutputStream
    implements IStateful {
        private IStatus status;

        public StatefulFileOutputStream(File file) throws FileNotFoundException {
            super(file);
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

