/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

public abstract class ActivityAdapter {
    private final TraverseListener traverseListener = new TraverseListener(){

        public final void keyTraversed(TraverseEvent e) {
            ActivityAdapter.this.handleActivity();
        }
    };
    private final KeyListener keyListener = new KeyListener(){

        public final void keyPressed(KeyEvent e) {
            ActivityAdapter.this.handleActivity();
        }

        public final void keyReleased(KeyEvent e) {
            ActivityAdapter.this.handleActivity();
        }
    };
    private final MouseListener mouseListener = new MouseListener(){

        public final void mouseUp(MouseEvent e) {
            ActivityAdapter.this.handleActivity();
        }

        public final void mouseDown(MouseEvent e) {
            ActivityAdapter.this.handleActivity();
        }

        public final void mouseDoubleClick(MouseEvent e) {
            ActivityAdapter.this.handleActivity();
        }
    };
    private final SelectionListener selectionListener = new SelectionListener(){

        public final void widgetSelected(SelectionEvent e) {
            ActivityAdapter.this.handleActivity();
        }

        public final void widgetDefaultSelected(SelectionEvent e) {
            ActivityAdapter.this.handleActivity();
        }
    };
    private final ModifyListener modifyListener = new ModifyListener(){

        public final void modifyText(ModifyEvent e) {
            ActivityAdapter.this.handleActivity();
        }
    };

    public void attach(Control control) {
        Button notifier;
        if (control instanceof Button) {
            notifier = (Button)control;
            notifier.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Text) {
            notifier = (Text)control;
            notifier.addTraverseListener(this.traverseListener);
            notifier.addKeyListener(this.keyListener);
            notifier.addMouseListener(this.mouseListener);
            notifier.addSelectionListener(this.selectionListener);
            notifier.addModifyListener(this.modifyListener);
        }
        if (control instanceof Link) {
            notifier = (Link)control;
            notifier.addTraverseListener(this.traverseListener);
            notifier.addKeyListener(this.keyListener);
            notifier.addMouseListener(this.mouseListener);
            notifier.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Combo) {
            notifier = (Combo)control;
            notifier.addTraverseListener(this.traverseListener);
            notifier.addKeyListener(this.keyListener);
            notifier.addMouseListener(this.mouseListener);
            notifier.addSelectionListener(this.selectionListener);
            notifier.addModifyListener(this.modifyListener);
        }
        if (control instanceof Tree) {
            notifier = (Tree)control;
            notifier.addTraverseListener(this.traverseListener);
            notifier.addKeyListener(this.keyListener);
            notifier.addMouseListener(this.mouseListener);
            notifier.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Table) {
            notifier = (Table)control;
            notifier.addTraverseListener(this.traverseListener);
            notifier.addKeyListener(this.keyListener);
            notifier.addMouseListener(this.mouseListener);
            notifier.addSelectionListener(this.selectionListener);
        }
        if (control instanceof ToolBar) {
            notifier = (ToolBar)control;
            notifier.addTraverseListener(this.traverseListener);
            notifier.addKeyListener(this.keyListener);
            notifier.addMouseListener(this.mouseListener);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.attach(child);
                ++n2;
            }
        }
    }

    protected abstract void handleActivity();
}

