/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.oomph.setup.ResourceCopyTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.Messages;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ZIPUtil;
import org.eclipse.osgi.util.NLS;

public class ResourceCopyTaskImpl
extends SetupTaskImpl
implements ResourceCopyTask {
    public static final String OPTION_ZIP_CACHE = "OPTION_ZIP_CACHE";
    protected static final boolean FORCE_EDEFAULT = false;
    protected boolean force = false;
    protected static final String SOURCE_URL_EDEFAULT = null;
    protected String sourceURL = SOURCE_URL_EDEFAULT;
    protected static final String TARGET_URL_EDEFAULT = null;
    protected String targetURL = TARGET_URL_EDEFAULT;

    protected ResourceCopyTaskImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SetupPackage.Literals.RESOURCE_COPY_TASK;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void setForce(boolean newForce) {
        boolean oldForce = this.force;
        this.force = newForce;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldForce, this.force));
        }
    }

    @Override
    public String getSourceURL() {
        return this.sourceURL;
    }

    @Override
    public void setSourceURL(String newSourceURL) {
        String oldSourceURL = this.sourceURL;
        this.sourceURL = newSourceURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldSourceURL, (Object)this.sourceURL));
        }
    }

    @Override
    public String getTargetURL() {
        return this.targetURL;
    }

    @Override
    public void setTargetURL(String newTargetURL) {
        String oldTargetURL = this.targetURL;
        this.targetURL = newTargetURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldTargetURL, (Object)this.targetURL));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isForce();
            }
            case 11: {
                return this.getSourceURL();
            }
            case 12: {
                return this.getTargetURL();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setForce((Boolean)newValue);
                return;
            }
            case 11: {
                this.setSourceURL((String)newValue);
                return;
            }
            case 12: {
                this.setTargetURL((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setForce(false);
                return;
            }
            case 11: {
                this.setSourceURL(SOURCE_URL_EDEFAULT);
                return;
            }
            case 12: {
                this.setTargetURL(TARGET_URL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.force;
            }
            case 11: {
                return SOURCE_URL_EDEFAULT == null ? this.sourceURL != null : !SOURCE_URL_EDEFAULT.equals(this.sourceURL);
            }
            case 12: {
                return TARGET_URL_EDEFAULT == null ? this.targetURL != null : !TARGET_URL_EDEFAULT.equals(this.targetURL);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (force: ");
        result.append(this.force);
        result.append(", sourceURL: ");
        result.append(this.sourceURL);
        result.append(", targetURL: ");
        result.append(this.targetURL);
        result.append(')');
        return result.toString();
    }

    @Override
    public int getProgressMonitorWork() {
        return 2;
    }

    protected boolean isFile(URI uri) {
        if (uri.isFile()) {
            return true;
        }
        URI archiveURI = this.getArchiveURI(uri);
        return archiveURI != null && archiveURI.isFile();
    }

    protected URI getArchiveURI(URI uri) {
        String authority;
        if (uri.isArchive() && (authority = uri.authority()) != null && authority.endsWith("!")) {
            URI archiveURI = URI.createURI((String)authority.substring(0, authority.length() - 1));
            archiveURI.appendQuery(uri.query());
            return archiveURI;
        }
        return null;
    }

    protected boolean isFolder(URI uri) {
        return uri.hasTrailingPathSeparator() || uri.lastSegment() == null;
    }

    @Override
    public boolean isNeeded(SetupTaskContext context) throws Exception {
        URI sourceURI = this.createResolvedURI(this.getSourceURL());
        URI targetURI = this.createResolvedURI(this.getTargetURL());
        if (sourceURI == null || targetURI == null) {
            return false;
        }
        URIConverter uriConverter = context.getURIConverter();
        if (this.isFolder(targetURI)) {
            if (this.isFolder(sourceURI)) {
                if (this.isFile(uriConverter.normalize(targetURI))) {
                    return this.isForce() || !uriConverter.exists(targetURI, null);
                }
                return true;
            }
            return this.isForce() || !uriConverter.exists(targetURI.appendSegment(sourceURI.lastSegment()), null);
        }
        return this.isForce() || !uriConverter.exists(targetURI, null);
    }

    protected void copy(URIConverter uriConverter, URI sourceURI, URI targetURI) throws IOException {
        InputStream input = null;
        OutputStream output = null;
        try {
            input = uriConverter.createInputStream(sourceURI, Collections.singletonMap(OPTION_ZIP_CACHE, Boolean.FALSE));
            output = uriConverter.createOutputStream(targetURI, null);
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(input);
            IOUtil.closeSilent(output);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)input);
        IOUtil.closeSilent((Closeable)output);
    }

    @Override
    public void perform(SetupTaskContext context) throws Exception {
        URI sourceURI = this.createResolvedURI(this.getSourceURL());
        URI targetURI = this.createResolvedURI(this.getTargetURL());
        URIConverter uriConverter = context.getURIConverter();
        URI normalizedSourceURI = uriConverter.normalize(sourceURI);
        URI normalizedTargetURI = uriConverter.normalize(targetURI);
        if (this.isFolder(targetURI)) {
            if (this.isFolder(sourceURI)) {
                if (normalizedSourceURI.isArchive() && this.isFile(normalizedTargetURI)) {
                    URI archiveURI = this.getArchiveURI(normalizedSourceURI);
                    if (this.isFile(archiveURI)) {
                        context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_UnzippingResource_message, (Object)normalizedSourceURI, (Object)normalizedTargetURI));
                        ZIPUtil.unzip((File)new File(archiveURI.toFileString()), (File)new File(normalizedTargetURI.toFileString()));
                    } else {
                        File tempZipFile = File.createTempFile("archive", "zip");
                        context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_DownloadingResource_message, (Object)uriConverter.normalize(archiveURI), (Object)tempZipFile));
                        this.copy(uriConverter, archiveURI, URI.createFileURI((String)tempZipFile.getAbsolutePath()));
                        context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_UnzippingTempFile_message, (Object)tempZipFile, (Object)normalizedTargetURI));
                        ZIPUtil.unzip((File)tempZipFile, (File)new File(normalizedTargetURI.toFileString()));
                    }
                } else if (this.isFile(normalizedTargetURI) && this.isFile(normalizedSourceURI)) {
                    context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_CopyingFolder_message, (Object)normalizedSourceURI, (Object)normalizedTargetURI));
                    IOUtil.copyTree((File)new File(normalizedSourceURI.toFileString()), (File)new File(normalizedTargetURI.toFileString()));
                } else {
                    context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_UnsupportedCopyingFolder_message, (Object)normalizedSourceURI, (Object)normalizedTargetURI));
                }
            } else if (uriConverter.exists(sourceURI, null)) {
                URI targetResourceURI = targetURI.appendSegment(sourceURI.lastSegment());
                context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_CopyingResource_message, (Object)normalizedSourceURI, (Object)uriConverter.normalize(targetResourceURI)));
                this.copy(uriConverter, sourceURI, targetResourceURI);
            }
        } else if (uriConverter.exists(sourceURI, null)) {
            context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_CopyingResource_message, (Object)normalizedSourceURI, (Object)normalizedTargetURI));
            this.copy(uriConverter, sourceURI, targetURI);
        } else {
            context.log(NLS.bind((String)Messages.ResourceCopyTaskImpl_CannotCopy_message, (Object)normalizedSourceURI, (Object)normalizedTargetURI));
        }
    }
}

