/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.repository;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.oomph.gitbash.AbstractAction;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixCRLFAction
extends AbstractAction<Repository> {
    private Dialog dialog;
    private Text text;

    public FixCRLFAction() {
        super(Repository.class);
    }

    @Override
    protected void run(Shell shell, Repository repository) {
        this.createDialog(shell);
        int fixCount = 0;
        ProgressMonitor monitor = new ProgressMonitor(){

            public void update(int completed) {
                FixCRLFAction.this.processDisplay();
            }

            public void start(int totalTasks) {
                FixCRLFAction.this.processDisplay();
            }

            public boolean isCancelled() {
                FixCRLFAction.this.processDisplay();
                return false;
            }

            public void endTask() {
                FixCRLFAction.this.processDisplay();
            }

            public void beginTask(String title, int totalWork) {
                FixCRLFAction.this.processDisplay();
            }
        };
        Repository targetRepository = null;
        try {
            try {
                File directory = repository.getDirectory();
                File workTree = repository.getWorkTree();
                this.log("Processing " + workTree);
                File targetWorkTree = new File(String.valueOf(workTree.getPath()) + ".fix.crlf");
                if (!targetWorkTree.mkdir()) {
                    this.log("Failed to create target folder:" + targetWorkTree);
                } else {
                    File targetDirectory = new File(targetWorkTree, ".git");
                    this.log("Copying " + directory + " to " + targetDirectory);
                    IOUtil.copyTree((File)directory, (File)targetDirectory);
                    this.log("Opening Git repository " + targetDirectory);
                    Git git = Git.open((File)targetDirectory);
                    targetRepository = git.getRepository();
                    this.log("Configuring AutoCRL to false " + targetDirectory);
                    StoredConfig config = targetRepository.getConfig();
                    config.setEnum("core", null, "autocrlf", (Enum)CoreConfig.AutoCRLF.FALSE);
                    config.save();
                    this.log("Resetting to create the working tree " + targetDirectory);
                    ResetCommand resetCommand = new ResetCommand(targetRepository);
                    resetCommand.setProgressMonitor(monitor);
                    resetCommand.setMode(ResetCommand.ResetType.HARD);
                    resetCommand.call();
                    this.log("Visiting tree " + targetDirectory);
                    FileTreeIterator fileTreeIterator = new FileTreeIterator(targetRepository);
                    while (!fileTreeIterator.eof()) {
                        fixCount += this.visit(fileTreeIterator.getEntryFile());
                        fileTreeIterator.next(1);
                    }
                    git.status().call();
                }
            }
            catch (Exception ex) {
                this.log("Failure");
                StringWriter out = new StringWriter();
                PrintWriter stackTrace = new PrintWriter(out);
                ex.printStackTrace(stackTrace);
                stackTrace.close();
                this.log(out.toString());
                if (targetRepository != null) {
                    this.log("Adding to repository view " + targetRepository.getWorkTree());
                    RepositoryUtil repositoryUtil = RepositoryUtil.getInstance();
                    repositoryUtil.addConfiguredRepository(targetRepository.getDirectory());
                    targetRepository.close();
                }
                return;
            }
        }
        finally {
            if (targetRepository != null) {
                this.log("Adding to repository view " + targetRepository.getWorkTree());
                RepositoryUtil repositoryUtil = RepositoryUtil.getInstance();
                repositoryUtil.addConfiguredRepository(targetRepository.getDirectory());
                targetRepository.close();
            }
        }
        if (fixCount == 0) {
            this.log("Done");
            this.log("No files needed fixing");
        } else {
            this.log(String.valueOf(fixCount) + " files fixed");
        }
    }

    private void log(String message) {
        this.text.append(String.valueOf(message) + "\n");
        this.processDisplay();
    }

    private void processDisplay() {
        while (this.text.getDisplay().readAndDispatch()) {
        }
    }

    private void createDialog(Shell shell) {
        final Point size = shell.getSize();
        this.dialog = new Dialog(shell){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Fix CRLF");
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                FixCRLFAction.this.text = new Text(composite, 770);
                GridData gridData = new GridData(4, 4, true, true);
                gridData.widthHint = size.x / 2;
                gridData.heightHint = size.y / 2;
                FixCRLFAction.this.text.setLayoutData((Object)gridData);
                return composite;
            }
        };
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    private int visit(File file) {
        int result = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result += this.visit(child);
                ++n2;
            }
        } else {
            byte[] bytes = IOUtil.readFile((File)file);
            if (RawText.isBinary((byte[])bytes)) {
                this.log("Ignoring binary " + file);
            } else {
                boolean modified = false;
                ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length);
                int i = 0;
                while (i < bytes.length) {
                    byte b = bytes[i];
                    if (b == 13 && i + 1 < bytes.length && bytes[i + 1] == 10) {
                        out.write(10);
                        ++i;
                        modified = true;
                    } else {
                        out.write(b);
                    }
                    ++i;
                }
                if (modified) {
                    this.log("Fixing " + file);
                    ++result;
                    IOUtil.writeFile((File)file, (byte[])out.toByteArray());
                }
            }
        }
        return result;
    }
}

