/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;

public class SynchronizerJob
extends Job {
    private final CountDownLatch done = new CountDownLatch(1);
    private final Synchronizer synchronizer;
    private final boolean deferLocal;
    private SynchronizerService service;
    private Synchronization synchronization;
    private Throwable exception;

    public SynchronizerJob(Synchronizer synchronizer, boolean deferLocal) {
        super("Synchronizing");
        this.synchronizer = synchronizer;
        this.deferLocal = deferLocal;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public boolean isDeferLocal() {
        return this.deferLocal;
    }

    public SynchronizerService getService() {
        return this.service;
    }

    public void setService(SynchronizerService service) {
        this.service = service;
    }

    public Synchronization getSynchronization() {
        return this.synchronization;
    }

    public Synchronization awaitSynchronization(long timeout, IProgressMonitor monitor) {
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while (!monitor.isCanceled()) {
            try {
                if (this.done.await(Math.max(timeout, 100L), TimeUnit.MILLISECONDS)) {
                    return this.synchronization;
                }
                now = System.currentTimeMillis();
                timeout = end - now;
                if (timeout > 0L) continue;
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
        return null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.synchronization = this.synchronizer.synchronize(this.deferLocal);
            this.done.countDown();
        }
        catch (Throwable ex) {
            this.exception = ex;
        }
        return Status.OK_STATUS;
    }

    public Throwable getException() {
        return this.exception;
    }
}

