/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.manifests;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractProjectHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IProject project = this.getProject(page);
        if (project != null) {
            this.execute(page, project);
        }
        return null;
    }

    private IProject getProject(IWorkbenchPage page) {
        IEditorInput input;
        IEditorPart editor;
        IStructuredSelection ssel;
        IResource resource = null;
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1) {
            Object element = ssel.getFirstElement();
            if (element instanceof IResource) {
                resource = (IResource)element;
            }
            if (resource == null && element instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
            if (resource == null) {
                resource = (IResource)Platform.getAdapterManager().getAdapter(element, IResource.class);
            }
        }
        if (resource == null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)input).getFile();
        }
        if (resource == null) {
            return null;
        }
        return resource.getProject();
    }

    protected abstract void execute(IWorkbenchPage var1, IProject var2);
}

