/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.util.regex.Matcher;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.PropertiesUtil;

public final class SetupUtil {
    private static final String DEFAULT_INSTALLER_UPDATE_URL = "http://download.eclipse.org/oomph/products/repository";
    public static final String INSTALLER_UPDATE_URL = PropertiesUtil.getProperty((String)"oomph.installer.update.url", (String)"http://download.eclipse.org/oomph/products/repository").replace('\\', '/');
    public static final String INSTALLER_PRODUCT_ID = "org.eclipse.oomph.setup.installer.product";

    private SetupUtil() {
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Matcher matcher = StringExpander.STRING_EXPANSION_PATTERN.matcher(string);
        while (matcher.find()) {
            String group1 = matcher.group(1);
            if ("$".equals(group1)) {
                matcher.appendReplacement(result, "\\$\\$\\$\\$");
                continue;
            }
            matcher.appendReplacement(result, "\\$$0");
        }
        matcher.appendTail(result);
        int i = 0;
        int length = result.length();
        while (i < length) {
            char c = result.charAt(i);
            if (c < StringExpander.CONTROL_CHARACTER_REPLACEMENTS.length && c != '\n' && c != '\r' && c != '\t') {
                String replacement = StringExpander.CONTROL_CHARACTER_REPLACEMENTS[c];
                result.replace(i, i + 1, replacement);
                length += replacement.length() - 1;
            }
            ++i;
        }
        return result.toString();
    }
}

