/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.osgi.framework.Version;

public final class VersionUtil {
    public static final String BUILDER_ID = "org.eclipse.oomph.version.VersionBuilder";
    public static final boolean DEBUG = Boolean.valueOf(System.getProperty("org.eclipse.oomph.version.debug", "false"));
    private static final IWorkspace WORKSPACE = ResourcesPlugin.getWorkspace();

    private VersionUtil() {
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static Version normalize(Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    public static IFile getFile(IPath path, String extension) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(path);
        IPath newPath = file.getFullPath().removeFileExtension().addFileExtension(extension);
        return root.getFile(newPath);
    }

    public static String getContents(IFile file) throws CoreException, IOException {
        InputStream contents = null;
        try {
            int c;
            contents = file.getContents();
            BufferedReader reader = new BufferedReader(new InputStreamReader(contents, file.getCharset()));
            CharArrayWriter caw = new CharArrayWriter();
            while ((c = reader.read()) != -1) {
                caw.write(c);
            }
            String string = caw.toString();
            return string;
        }
        finally {
            IOUtil.closeSilent((Closeable)contents);
        }
    }

    /*
     * Exception decompiling
     */
    public static String getLineDelimiter(IFile file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized byte[] getSHA1(IFile file) throws NoSuchAlgorithmException, CoreException, IOException {
        InputStream contents = file.getContents();
        return IOUtil.getSHA1((InputStream)contents);
    }

    public static IModel getComponentModel(IProject project) {
        IPluginModelBase componentModel = PluginRegistry.findModel((IProject)project);
        if (componentModel == null && (componentModel = VersionUtil.getFeatureModel(project)) == null) {
            throw new IllegalStateException("The project " + project.getName() + " is neither a plugin nor a feature");
        }
        return componentModel;
    }

    public static IFeatureModel getFeatureModel(IProject project) {
        IFeatureModel[] featureModels;
        IFeatureModel[] iFeatureModelArray = featureModels = PDECore.getDefault().getFeatureModelManager().getWorkspaceModels();
        int n = featureModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel featureModel = iFeatureModelArray[n2];
            if (featureModel.getUnderlyingResource().getProject() == project) {
                return featureModel;
            }
            ++n2;
        }
        return null;
    }

    public static Version getComponentVersion(IModel componentModel) {
        if (componentModel instanceof IPluginModelBase) {
            IPluginModelBase pluginModel = (IPluginModelBase)componentModel;
            return VersionUtil.normalize(pluginModel.getBundleDescription().getVersion());
        }
        Version version = new Version(((IFeatureModel)componentModel).getFeature().getVersion());
        return VersionUtil.normalize(version);
    }

    public static void cleanReleaseProjects(final String releasePath) {
        new Job("Cleaning workspace"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBuildConfiguration[] buildConfigs = VersionUtil.getBuildConfigs(releasePath);
                    WORKSPACE.build(buildConfigs, 15, true, monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
            }
        }.schedule();
    }

    private static IBuildConfiguration[] getBuildConfigs(String releasePath) {
        ArrayList<IBuildConfiguration> buildConfigs = new ArrayList<IBuildConfiguration>();
        IProject[] iProjectArray = WORKSPACE.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                try {
                    ICommand[] commands;
                    ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
                    int n3 = commands.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICommand command = iCommandArray[n4];
                        if (BUILDER_ID.equals(command.getBuilderName())) {
                            VersionBuilderArguments arguments = new VersionBuilderArguments(project);
                            String projectReleasePath = arguments.getReleasePath();
                            if (releasePath.equals(projectReleasePath)) {
                                IBuildConfiguration buildConfig = project.getActiveBuildConfig();
                                buildConfigs.add(buildConfig);
                            }
                            break;
                        }
                        ++n4;
                    }
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
            ++n2;
        }
        return buildConfigs.toArray(new IBuildConfiguration[buildConfigs.size()]);
    }

    public static IBuild getBuild(IModel componentModel) throws CoreException {
        IBuildModel buildModel = VersionUtil.getBuildModel(componentModel);
        IBuild build = buildModel.getBuild();
        if (build == null) {
            throw new IllegalStateException("Could not determine build model for " + VersionUtil.getName(componentModel));
        }
        return build;
    }

    public static IBuildModel getBuildModel(IModel componentModel) throws CoreException {
        IFile buildFile;
        IProject project = componentModel.getUnderlyingResource().getProject();
        if (project != null && (buildFile = PDEProject.getBuildProperties((IProject)project)).exists()) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
            return buildModel;
        }
        throw new IllegalStateException("Could not determine build model for " + VersionUtil.getName(componentModel));
    }

    private static String getName(IModel componentModel) {
        if (componentModel instanceof IPluginModelBase) {
            IPluginModelBase pluginModel = (IPluginModelBase)componentModel;
            return pluginModel.getBundleDescription().getSymbolicName();
        }
        return ((IFeatureModel)componentModel).getFeature().getId();
    }
}

