/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.net.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.setup.internal.sync.SynchronizerCredentials;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SynchronizerLoginComposite
extends Composite {
    private final ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SynchronizerLoginComposite.this.credentials = new SynchronizerCredentials(SynchronizerLoginComposite.this.usernameText.getText(), SynchronizerLoginComposite.this.passwordText.getText());
            SynchronizerLoginComposite.this.validate();
        }
    };
    private SynchronizerService service;
    private SynchronizerCredentials credentials;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Link signupLink;

    public SynchronizerLoginComposite(Composite parent, int style, int marginWidth, int marginHeight) {
        super(parent, style);
        GridLayout layout = UIUtil.createGridLayout((int)this.getGridColumns());
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        this.setLayout((Layout)layout);
        this.createUI(this, layout.numColumns);
    }

    public SynchronizerService getService() {
        return this.service;
    }

    public void setService(SynchronizerService service) {
        this.signupLink.setVisible(false);
        this.service = service;
        if (service != null) {
            URI signupURI = service.getSignupURI();
            if (signupURI != null) {
                String label = this.getServiceLabel(service);
                this.signupLink.setText("<a>Create an " + label + " account</a>");
                this.signupLink.setVisible(true);
            }
            this.setCredentials(service.getCredentials());
        }
    }

    public SynchronizerCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(SynchronizerCredentials credentials) {
        this.credentials = credentials;
        if (credentials != null) {
            this.usernameText.setText(StringUtil.safe((String)credentials.getUsername()));
            this.passwordText.setText(StringUtil.safe((String)credentials.getPassword()));
        } else {
            this.usernameText.setText("");
            this.passwordText.setText("");
        }
    }

    public int getGridColumns() {
        return 2;
    }

    public void setEnabled(boolean enabled) {
        this.usernameLabel.setEnabled(enabled);
        this.usernameText.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.passwordText.setEnabled(enabled);
        this.signupLink.setEnabled(enabled);
    }

    protected void createUI(Composite parent, int columns) {
        this.usernameLabel = new Label(parent, 0);
        this.usernameLabel.setText("User name:");
        this.usernameText = new Text(parent, 2048);
        this.usernameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns - 1, 1));
        this.usernameText.addModifyListener(this.listener);
        this.usernameText.setFocus();
        this.passwordLabel = new Label(parent, 0);
        this.passwordLabel.setText("Password:");
        this.passwordText = new Text(parent, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns - 1, 1));
        this.passwordText.addModifyListener(this.listener);
        new Label(parent, 0);
        this.signupLink = new Link(parent, 0);
        this.signupLink.setLayoutData((Object)new GridData(4, 4, true, true, columns - 1, 1));
        this.signupLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uri = SynchronizerLoginComposite.this.service.getSignupURI().toString();
                if (!OS.INSTANCE.openSystemBrowser(uri)) {
                    String serviceLabel = SynchronizerLoginComposite.this.getServiceLabel(SynchronizerLoginComposite.this.service);
                    MessageDialog.openInformation((Shell)SynchronizerLoginComposite.this.getShell(), (String)"System Browser Not Found", (String)("Go to " + uri + " to create an " + serviceLabel + " account."));
                }
            }
        });
    }

    protected void validate() {
    }

    private String getServiceLabel(SynchronizerService service) {
        String label = service.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = service.getServiceURI().toString();
        }
        return label;
    }
}

