/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.Element;
import org.eclipse.oomph.internal.version.Release;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IRelease;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseManager
implements IReleaseManager {
    private Map<IRelease, Long> releases = new WeakHashMap<IRelease, Long>();
    private SAXParserFactory parserFactory;

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        return this.parserFactory.newSAXParser();
    }

    @Override
    public synchronized IRelease getRelease(IFile file) throws CoreException {
        try {
            IRelease release;
            for (Map.Entry<IRelease, Long> entry : this.releases.entrySet()) {
                release = entry.getKey();
                if (!release.getFile().equals((Object)file)) continue;
                long timeStamp = entry.getValue();
                if (file.getLocalTimeStamp() == timeStamp) {
                    return release;
                }
                this.releases.remove(release);
                break;
            }
            String releasePath = file.getFullPath().toString();
            Activator.ReleaseCheckMode releaseCheckMode = Activator.getReleaseCheckMode(releasePath);
            if (releaseCheckMode == null) {
                Activator.setReleaseCheckMode(releasePath, Activator.ReleaseCheckMode.FULL);
            }
            if (!file.exists()) {
                throw new FileNotFoundException(releasePath);
            }
            release = new Release(this.getParser(), file);
            this.releases.put(release, file.getLocalTimeStamp());
            return release;
        }
        catch (CoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.oomph.version", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    @Override
    public Map<IElement, IElement> createElements(String path, boolean resolve) {
        HashMap<IElement, IElement> elements = new HashMap<IElement, IElement>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionBuilderArguments args;
            String releasePath;
            IProject project = iProjectArray[n2];
            if (project.isOpen() && path.equals(releasePath = (args = new VersionBuilderArguments(project)).getReleasePath())) {
                IModel componentModel = VersionUtil.getComponentModel(project);
                IElement element = this.createElement(componentModel, true, resolve);
                elements.put(element, element);
            }
            ++n2;
        }
        Set keySet = elements.keySet();
        ArrayList queue = new ArrayList(keySet);
        int i = 0;
        while (i < queue.size()) {
            IElement element = (IElement)queue.get(i);
            for (IElement child : element.getChildren()) {
                if (elements.containsKey(child)) continue;
                IModel childModel = this.getComponentModel(child.trimVersion());
                if (childModel != null) {
                    IElement topElement = this.createElement(childModel, true, resolve);
                    queue.add(topElement);
                    elements.put(topElement, topElement);
                    continue;
                }
                elements.put(child, child);
            }
            ++i;
        }
        return elements;
    }

    @Override
    public synchronized IRelease createRelease(IFile file) throws CoreException, IOException, NoSuchAlgorithmException {
        Release release = new Release(file);
        String path = file.getFullPath().toString();
        release.getElements().putAll(this.createElements(path, true));
        release.write();
        this.releases.put(release, file.getLocalTimeStamp());
        return release;
    }

    @Override
    public IElement createElement(IModel componentModel, boolean withFeatureContent, boolean resolve) {
        if (componentModel instanceof IPluginModelBase) {
            IPluginModelBase pluginModel = (IPluginModelBase)componentModel;
            BundleDescription description = pluginModel.getBundleDescription();
            if (description == null) {
                throw new IllegalStateException("No bundle description for " + pluginModel.getInstallLocation());
            }
            String name = description.getSymbolicName();
            Version version = description.getVersion();
            return new Element(IElement.Type.PLUGIN, name, version);
        }
        return this.createFeatureElement(componentModel, withFeatureContent, resolve);
    }

    private IElement createFeatureElement(IModel componentModel, boolean withContent, boolean resolve) {
        IFeatureModel featureModel = (IFeatureModel)componentModel;
        IFeature feature = featureModel.getFeature();
        String name = feature.getId();
        String versionValue = feature.getVersion();
        Version version = new Version(StringUtil.isEmpty((String)versionValue) ? "1.0.0.qualifier" : versionValue);
        Element element = new Element(IElement.Type.FEATURE, name, version);
        if (withContent) {
            Element child;
            IFeatureChild versionable;
            String licenseFeatureID = feature.getLicenseFeatureID();
            if (licenseFeatureID.length() != 0) {
                Element child2 = new Element(IElement.Type.FEATURE, licenseFeatureID, feature.getLicenseFeatureVersion());
                if (resolve) {
                    child2.resolveVersion();
                }
                child2.setLicenseFeature(true);
                element.getChildren().add(child2);
            }
            IFeatureChild[] iFeatureChildArray = feature.getIncludedFeatures();
            int n = iFeatureChildArray.length;
            int n2 = 0;
            while (n2 < n) {
                versionable = iFeatureChildArray[n2];
                child = new Element(IElement.Type.FEATURE, versionable.getId(), versionable.getVersion());
                if (resolve) {
                    child.resolveVersion();
                }
                element.getChildren().add(child);
                ++n2;
            }
            iFeatureChildArray = feature.getPlugins();
            n = iFeatureChildArray.length;
            n2 = 0;
            while (n2 < n) {
                versionable = iFeatureChildArray[n2];
                child = new Element(IElement.Type.PLUGIN, versionable.getId(), versionable.getVersion());
                if (resolve) {
                    child.resolveVersion();
                }
                element.getChildren().add(child);
                ++n2;
            }
        }
        return element;
    }

    @Override
    public IModel getComponentModel(IElement element) {
        String name = element.getName();
        if (element.getType() == IElement.Type.PLUGIN) {
            IPluginModelBase model = PluginRegistry.findModel((String)name);
            if (name.endsWith(".source") && model != null && model.getUnderlyingResource() == null) {
                return null;
            }
            if (!element.isVersionUnresolved()) {
                Version pluginVersion = VersionUtil.normalize(model.getBundleDescription().getVersion());
                if (!element.getVersion().equals((Object)pluginVersion)) {
                    return null;
                }
            }
            return model;
        }
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] featureModels = manager.getWorkspaceModels();
        IFeatureModel featureModel = this.getFeatureModel(name, featureModels);
        if (featureModel == null && (featureModel = this.getFeatureModel(name, featureModels = manager.getExternalModels())) == null) {
            return null;
        }
        if (name.endsWith(".source") && featureModel.getUnderlyingResource() == null) {
            return null;
        }
        if (!element.isVersionUnresolved()) {
            IFeature feature = featureModel.getFeature();
            Version featureVersion = VersionUtil.normalize(new Version(feature.getVersion()));
            if (!element.getVersion().equals((Object)featureVersion)) {
                return null;
            }
        }
        return featureModel;
    }

    private IFeatureModel getFeatureModel(String name, IFeatureModel[] featureModels) {
        Version highestVersion = null;
        IFeatureModel highestModel = null;
        IFeatureModel[] iFeatureModelArray = featureModels;
        int n = featureModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel featureModel = iFeatureModelArray[n2];
            IFeature feature = featureModel.getFeature();
            String id = feature.getId();
            if (id.equals(name)) {
                Version newVersion = new Version(feature.getVersion());
                if (highestVersion == null || highestVersion.compareTo(newVersion) < 0) {
                    highestVersion = newVersion;
                    highestModel = featureModel;
                }
            }
            ++n2;
        }
        if (highestModel == null) {
            return null;
        }
        return highestModel;
    }
}

