/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.RequirementType;
import org.eclipse.oomph.targlets.ComponentExtGenerator;
import org.eclipse.oomph.targlets.ComponentExtension;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentExtGeneratorImpl
extends ModelElementImpl
implements ComponentExtGenerator {
    private static final IPath EXTENSION_PATH = new Path("component.ext");

    protected ComponentExtGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.COMPONENT_EXT_GENERATOR;
    }

    @Override
    public void generateIUs(IProject project, String qualifierReplacement, Map<String, Version> iuVersions, EList<IInstallableUnit> result) throws Exception {
        if (!result.isEmpty()) {
            IInstallableUnit mainIU = (IInstallableUnit)result.get(0);
            IFile file = project.getFile(EXTENSION_PATH);
            if (file.exists()) {
                InputStream inputStream = null;
                try {
                    inputStream = file.getContents();
                    Resource resource = new BaseResourceFactoryImpl().createResource(null);
                    resource.load(inputStream, null);
                    ComponentExtension componentExtension = (ComponentExtension)BaseUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)TargletPackage.Literals.COMPONENT_EXTENSION);
                    ComponentExtGeneratorImpl.modifyIU(componentExtension, mainIU);
                }
                finally {
                    IOUtil.closeSilent((Closeable)inputStream);
                }
            }
        }
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2), (EList<IInstallableUnit>)((EList)arguments.get(3)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    static void modifyIU(ComponentExtension componentExtension, IInstallableUnit host) throws Exception {
        if (host instanceof InstallableUnit) {
            InstallableUnit iu = (InstallableUnit)host;
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>(iu.getRequirements());
            for (Requirement requirement : componentExtension.getRequirements()) {
                String id = requirement.getName();
                VersionRange versionRange = requirement.getVersionRange();
                String namespace = requirement.getType() != RequirementType.NONE ? "org.eclipse.equinox.p2.iu" : "osgi.bundle";
                requirements.add(MetadataFactory.createRequirement((String)namespace, (String)id, (VersionRange)versionRange, (String)requirement.getFilter(), (boolean)requirement.isOptional(), (boolean)true, (boolean)true));
            }
            iu.setRequiredCapabilities(requirements.toArray(new IRequirement[requirements.size()]));
        }
    }
}

