/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.repository;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.oomph.gitbash.AbstractAction;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCopyrightsAction
extends AbstractAction<Repository> {
    private static final String[] DEFAULT_IGNORED_MESSAGE_VERBS = new String[]{"update", "adjust", "fix"};
    private static final String[] DEFAULT_IGNORED_MESSAGE_NOUNS = new String[]{"copyright", "legal header"};
    private static final String[] DEFAULT_IGNORED_PATHS = new String[]{"target", "resourcemanager.java"};
    private static final String[] DEFAULT_CHECK_FILES = new String[]{".java", ".ant", "build.xml", "plugin.xml", "fragment.xml", "feature.xml", "plugin.properties", "fragment.properties", "feature.properties", "about.properties", "build.properties", "messages.properties", "copyright.txt", ".exsd", "org.eclipse.jdt.ui.prefs"};
    private static final String[] DEFAULT_UPDATE_FILES = new String[]{".properties", ".xml", ".css", ".ecore", ".genmodel", ".mwe", ".xpt", ".ext"};
    private static final String DEFAULT_COPYRIGHT_PATTERN = "(.*?)Copyright \\(c\\) ([0-9 ,-]+) (.*?) and others\\.(.*)";
    private static final Calendar CALENDAR = GregorianCalendar.getInstance();
    private static final int CURRENT_YEAR = CALENDAR.get(1);
    private static final String CURRENT_YEAR_STRING = Integer.toString(CURRENT_YEAR);
    private static final IWorkbench WORKBENCH = PlatformUI.getWorkbench();
    private static final String NL = System.getProperty("line.separator");
    private Git git;
    private File workTree;
    private int workTreeLength;
    private String[] ignoredMessages;
    private String[] ignoredPaths;
    private Pattern[] checkFiles;
    private Pattern[] updateFiles;
    private Pattern copyrightPattern;
    private List<String> missingCopyrights = new ArrayList<String>();
    private int rewriteCount;
    private File stateFile;

    public UpdateCopyrightsAction() {
        super(Repository.class);
    }

    protected boolean isCheckOnly() {
        return false;
    }

    @Override
    protected void run(final Shell shell, final Repository repository) throws Exception {
        new Job(this.getTitle()){

            protected IStatus run(IProgressMonitor monitor) {
                block9: {
                    BufferedWriter stateWriter = null;
                    try {
                        UpdateCopyrightsAction.this.git = new Git(repository);
                        UpdateCopyrightsAction.this.workTree = repository.getWorkTree();
                        UpdateCopyrightsAction.this.workTreeLength = UpdateCopyrightsAction.this.workTree.getAbsolutePath().length() + 1;
                        UpdateCopyrightsAction.this.stateFile = new File(UpdateCopyrightsAction.this.workTree, ".legalchecks.state");
                        UpdateCopyrightsAction.this.initProperties();
                        Set finishedFiles = UpdateCopyrightsAction.this.initState();
                        final Boolean[] skipFinishedFiles = new Boolean[]{false};
                        if (finishedFiles != null && !finishedFiles.isEmpty()) {
                            final String message = String.valueOf(finishedFiles.size()) + " files have been previously processed.\nDo you want to skip these files?";
                            shell.getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    skipFinishedFiles[0] = MessageDialog.openQuestion((Shell)shell, (String)UpdateCopyrightsAction.this.getTitle(), (String)message);
                                }
                            });
                        }
                        if (!skipFinishedFiles[0].booleanValue()) {
                            UpdateCopyrightsAction.this.stateFile.delete();
                            finishedFiles = null;
                        }
                        stateWriter = new BufferedWriter(new FileWriter(UpdateCopyrightsAction.this.stateFile, true));
                        final TreeMap files = new TreeMap();
                        UpdateCopyrightsAction.this.collectFiles(files, finishedFiles, UpdateCopyrightsAction.this.workTree, monitor);
                        monitor.beginTask(UpdateCopyrightsAction.this.getTitle(), files.size());
                        final long start = System.currentTimeMillis();
                        UpdateCopyrightsAction.this.checkFiles(files, stateWriter, start, monitor);
                        UpdateCopyrightsAction.close(stateWriter);
                        stateWriter = null;
                        UpdateCopyrightsAction.this.stateFile.delete();
                        shell.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                try {
                                    UpdateCopyrightsAction.this.handleResult(shell, UpdateCopyrightsAction.this.workTree, files.size(), UpdateCopyrightsAction.formatDuration(start));
                                }
                                catch (Exception ex) {
                                    Activator.log(ex);
                                }
                            }
                        });
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        UpdateCopyrightsAction.close(stateWriter);
                        UpdateCopyrightsAction.this.missingCopyrights.clear();
                        UpdateCopyrightsAction.this.rewriteCount = 0;
                        UpdateCopyrightsAction.this.workTreeLength = 0;
                        UpdateCopyrightsAction.this.workTree = null;
                        UpdateCopyrightsAction.this.git = null;
                        monitor.done();
                        break block9;
                    }
                    catch (Exception ex) {
                        try {
                            Activator.log(ex);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            UpdateCopyrightsAction.close(stateWriter);
                            UpdateCopyrightsAction.this.missingCopyrights.clear();
                            UpdateCopyrightsAction.this.rewriteCount = 0;
                            UpdateCopyrightsAction.this.workTreeLength = 0;
                            UpdateCopyrightsAction.this.workTree = null;
                            UpdateCopyrightsAction.this.git = null;
                            monitor.done();
                        }
                    }
                    UpdateCopyrightsAction.close(stateWriter);
                    UpdateCopyrightsAction.this.missingCopyrights.clear();
                    UpdateCopyrightsAction.this.rewriteCount = 0;
                    UpdateCopyrightsAction.this.workTreeLength = 0;
                    UpdateCopyrightsAction.this.workTree = null;
                    UpdateCopyrightsAction.this.git = null;
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initProperties() {
        Properties properties;
        block7: {
            properties = new Properties();
            File file = new File(this.workTree, ".legalchecks");
            if (file.isFile()) {
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(file);
                        properties.load(in);
                    }
                    catch (IOException ex) {
                        Activator.log(ex);
                        UpdateCopyrightsAction.close(in);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    UpdateCopyrightsAction.close(in);
                    throw throwable;
                }
                UpdateCopyrightsAction.close(in);
            }
        }
        this.ignoredMessages = UpdateCopyrightsAction.combineWords(this.getStrings(properties, "ignored.message.verbs", DEFAULT_IGNORED_MESSAGE_VERBS), this.getStrings(properties, "ignored.message.nouns", DEFAULT_IGNORED_MESSAGE_NOUNS));
        this.ignoredPaths = this.getStrings(properties, "ignored.paths", DEFAULT_IGNORED_PATHS);
        this.checkFiles = this.getPatterns(properties, "check.files", DEFAULT_CHECK_FILES);
        this.updateFiles = this.getPatterns(properties, "update.files", DEFAULT_UPDATE_FILES);
        String property = properties.getProperty("copyright.pattern");
        if (property == null) {
            property = DEFAULT_COPYRIGHT_PATTERN;
        }
        this.copyrightPattern = Pattern.compile(property);
    }

    private Set<File> initState() {
        this.stateFile = new File(this.workTree, ".legalchecks.state");
        if (this.stateFile.isFile()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.stateFile));
                HashSet<File> finishedFiles = new HashSet<File>();
                while ((line = reader.readLine()) != null) {
                    finishedFiles.add(new File(line));
                }
                HashSet<File> hashSet = finishedFiles;
                UpdateCopyrightsAction.close(reader);
                return hashSet;
            }
            catch (IOException ex) {
                Activator.log(ex);
            }
            finally {
                UpdateCopyrightsAction.close(reader);
            }
        }
        return null;
    }

    private String[] getStrings(Properties properties, String key, String[] defaultValue) {
        String property = properties.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        String[] result = property.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    private Pattern[] getPatterns(Properties properties, String key, String[] defaultValue) {
        String[] strings = this.getStrings(properties, key, defaultValue);
        Pattern[] result = new Pattern[strings.length];
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            string = string.replace(".", "\\.");
            string = string.replace("*", ".*");
            string = string.replace("?", ".");
            result[i] = Pattern.compile(string);
            ++i;
        }
        return result;
    }

    private void collectFiles(Map<File, Boolean> files, Set<File> finishedFiles, File folder, IProgressMonitor monitor) throws Exception {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String path = this.getWorkTreeRelativePath(file);
            if (!this.hasString(path, this.ignoredPaths)) {
                String name = file.getName();
                if (file.isDirectory()) {
                    if (!name.equals(".git") && !name.equals("bin")) {
                        this.collectFiles(files, finishedFiles, file, monitor);
                    }
                } else if (!(finishedFiles != null && finishedFiles.contains(file) || name.endsWith(".class"))) {
                    boolean required = this.matches(file, this.checkFiles);
                    if (required) {
                        files.put(file, true);
                    } else if (!this.isCheckOnly() && this.matches(file, this.updateFiles)) {
                        files.put(file, false);
                    }
                }
            }
            ++n2;
        }
    }

    private void checkFiles(Map<File, Boolean> files, BufferedWriter stateWriter, long start, IProgressMonitor monitor) throws Exception {
        int i = 0;
        int totalFiles = files.size();
        for (Map.Entry<File, Boolean> entry : files.entrySet()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            File file = entry.getKey();
            boolean required = entry.getValue();
            this.checkFile(file, required);
            monitor.worked(1);
            stateWriter.write(file.toString());
            stateWriter.write(NL);
            double millis = System.currentTimeMillis() - start;
            double millisPerFile = millis / (double)(++i);
            int remainingFiles = totalFiles - i;
            int remainingSeconds = (int)(millisPerFile * (double)remainingFiles / 1000.0);
            int remainingMinutes = remainingSeconds / 60;
            monitor.subTask("Remaining files: " + remainingFiles + ", remaining minutes: " + remainingMinutes + ":" + String.format("%02d", remainingSeconds -= remainingMinutes * 60));
        }
    }

    private void checkFile(File file, boolean required) throws Exception {
        String path = this.getWorkTreeRelativePath(file);
        ArrayList<String> lines = new ArrayList<String>();
        boolean copyrightFound = false;
        boolean copyrightChanged = false;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                Matcher matcher = this.copyrightPattern.matcher(line);
                if (matcher.matches()) {
                    String suffix;
                    String owner;
                    copyrightFound = true;
                    if (this.isCheckOnly()) {
                        break;
                    }
                    String dates = matcher.group(2);
                    if (dates.endsWith(CURRENT_YEAR_STRING)) {
                        break;
                    }
                    String prefix = matcher.group(1);
                    String newLine = this.rewriteCopyright(path, line, prefix, dates, owner = matcher.group(3), suffix = matcher.group(4));
                    if (newLine != line) {
                        line = newLine;
                        copyrightChanged = true;
                    }
                }
                lines.add(line);
            }
        }
        finally {
            UpdateCopyrightsAction.close(bufferedReader);
            UpdateCopyrightsAction.close(fileReader);
        }
        if (required && !copyrightFound) {
            this.missingCopyrights.add(path);
        }
        if (copyrightChanged) {
            UpdateCopyrightsAction.writeLines(file, lines);
            ++this.rewriteCount;
        }
    }

    private String rewriteCopyright(String path, String line, String prefix, String dates, String owner, String suffix) throws Exception {
        String newDates;
        if (path.endsWith("org.eclipse.jdt.ui.prefs")) {
            newDates = CURRENT_YEAR_STRING;
        } else if (path.endsWith("copyright.txt") || path.endsWith("org.eclipse.emf.cdo.license-feature/feature.properties") || suffix.equals(" All rights reserved.\\n\\")) {
            newDates = "2004-" + CURRENT_YEAR;
        } else {
            HashSet<Integer> years = new HashSet<Integer>();
            for (RevCommit commit : this.git.log().addPath(path).call()) {
                String message = commit.getFullMessage();
                if (this.hasString(message, this.ignoredMessages)) continue;
                CALENDAR.setTimeInMillis(1000L * (long)commit.getCommitTime());
                int year = CALENDAR.get(1);
                years.add(year);
            }
            if (years.isEmpty()) {
                return line;
            }
            newDates = this.formatYears(years);
        }
        if (newDates.equals(dates)) {
            return line;
        }
        return String.valueOf(prefix) + "Copyright (c) " + newDates + " " + owner + " and others." + suffix;
    }

    private String formatYears(Collection<Integer> years) {
        ArrayList<Integer> list = new ArrayList<Integer>(years);
        Collections.sort(list);
        class YearRange {
            private int begin;
            private int end;

            public YearRange(int begin) {
                this.begin = begin;
                this.end = begin;
            }

            public boolean add(int year) {
                if (year == this.end + 1) {
                    this.end = year;
                    return true;
                }
                return false;
            }

            public String toString() {
                if (this.begin == this.end) {
                    return "" + this.begin;
                }
                if (this.begin == this.end - 1) {
                    return this.begin + ", " + this.end;
                }
                return this.begin + "-" + this.end;
            }
        }
        ArrayList<YearRange> ranges = new ArrayList<YearRange>();
        YearRange lastRange = null;
        for (Integer year : list) {
            if (lastRange != null && lastRange.add(year)) continue;
            lastRange = new YearRange(year);
            ranges.add(lastRange);
        }
        StringBuilder builder = new StringBuilder();
        for (YearRange range : ranges) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(range);
        }
        return builder.toString();
    }

    private String getTitle() {
        return String.valueOf(this.isCheckOnly() ? "Check" : "Update") + " Copyrights";
    }

    private String getWorkTreeRelativePath(File file) {
        String path = file.getAbsolutePath().replace('\\', '/');
        return path.substring(this.workTreeLength);
    }

    private boolean hasString(String string, String[] strings) {
        string = string.toLowerCase();
        int i = 0;
        while (i < strings.length) {
            if (string.indexOf(strings[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matches(File file, Pattern[] patterns) {
        String fileName = file.getName().toLowerCase();
        int i = 0;
        while (i < patterns.length) {
            if (patterns[i].matcher(fileName).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleResult(Shell shell, File workTree, int fileCount, String duration) throws PartInitException {
        String message = "Copyrights missing: " + this.missingCopyrights.size();
        message = String.valueOf(message) + "\nCopyrights rewritten: " + this.rewriteCount;
        message = String.valueOf(message) + "\nFiles visited: " + fileCount;
        message = String.valueOf(message) + "\nTime needed: " + duration;
        int size = this.missingCopyrights.size();
        if (size != 0) {
            StringBuilder builder = new StringBuilder(message);
            message = String.valueOf(message) + "\n\nDo you want to open the files with missing copyrights in editors?";
            if (MessageDialog.openQuestion((Shell)shell, (String)this.getTitle(), (String)message)) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IWorkbenchPage page = WORKBENCH.getActiveWorkbenchWindow().getActivePage();
                builder.append("\n");
                for (String missingCopyright : this.missingCopyrights) {
                    builder.append("\nMissing: ");
                    builder.append(missingCopyright);
                    File externalFile = new File(workTree, missingCopyright);
                    IFile file = root.getFileForLocation((IPath)new Path(externalFile.getAbsolutePath()));
                    if (file != null && file.isAccessible()) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        continue;
                    }
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(externalFile.toURI());
                    if (fileStore == null) continue;
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                Activator.log((IStatus)new Status(2, "org.eclipse.oomph.gitbash", builder.toString()));
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)this.getTitle(), (String)message);
            Activator.log((IStatus)new Status(1, "org.eclipse.oomph.gitbash", message));
        }
    }

    private static String[] combineWords(String[] verbs, String[] nouns) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = nouns;
        int n = nouns.length;
        int n2 = 0;
        while (n2 < n) {
            String noun = stringArray[n2];
            String[] stringArray2 = verbs;
            int n3 = verbs.length;
            int n4 = 0;
            while (n4 < n3) {
                String verb = stringArray2[n4];
                result.add(String.valueOf(verb) + " " + noun);
                verb = verb.endsWith("e") ? String.valueOf(verb) + "d" : String.valueOf(verb) + "ed";
                result.add(String.valueOf(verb) + " " + noun);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String formatDuration(long start) {
        double duration = System.currentTimeMillis() - start;
        String unit = "milliseconds";
        if (duration > 1000.0) {
            duration /= 1000.0;
            unit = "seconds";
            if (duration > 60.0) {
                duration /= 60.0;
                unit = "minutes";
                if (duration > 60.0) {
                    duration /= 60.0;
                    unit = "hours";
                }
            }
        }
        duration = (double)Math.round(duration * 100.0) / 100.0;
        return String.valueOf(duration) + " " + unit;
    }

    private static void writeLines(File file, List<String> lines) throws IOException {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.write(NL);
            }
        }
        catch (Throwable throwable) {
            UpdateCopyrightsAction.close(bufferedWriter);
            UpdateCopyrightsAction.close(fileWriter);
            throw throwable;
        }
        UpdateCopyrightsAction.close(bufferedWriter);
        UpdateCopyrightsAction.close(fileWriter);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                Activator.log(ex);
            }
        }
    }
}

