/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.launches;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.oomph.launches.Activator;
import org.eclipse.swt.graphics.Image;

public class LaunchConfigLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    private static final ImageDescriptor LOCAL_OVERLAY = Activator.getImageDescriptor("local_ovr");
    private static final ImageDescriptor EXAMPLE_OVERLAY = Activator.getImageDescriptor("example_ovr");
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public Image decorateImage(Image image, Object element) {
        if (this.isLocal(element)) {
            DecorationOverlayIcon icon = new DecorationOverlayIcon(image, LOCAL_OVERLAY, 0);
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)icon);
        }
        if (this.isExampleCopy(element)) {
            DecorationOverlayIcon icon = new DecorationOverlayIcon(image, EXAMPLE_OVERLAY, 0);
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)icon);
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        if (this.isLocal(element)) {
            return "* " + text + " [local]";
        }
        if (this.isExampleCopy(element)) {
            return "~ " + text + " [example]";
        }
        return null;
    }

    private boolean isLocal(Object element) {
        if (element instanceof ILaunchConfiguration) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)element;
            return configuration.isLocal();
        }
        return false;
    }

    private boolean isExampleCopy(Object element) {
        ILaunchConfiguration configuration;
        IFile file;
        if (element instanceof ILaunchConfiguration && (file = (configuration = (ILaunchConfiguration)element).getFile()) != null) {
            IPath path = file.getFullPath();
            String[] segments = path.segments();
            return segments.length == 4 && segments[1].equals("examples");
        }
        return false;
    }
}

