/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.sorted.immutable;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Comparator;
import java.util.SortedMap;
import org.eclipse.collections.api.factory.map.sorted.ImmutableSortedMapFactory;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.impl.map.sorted.immutable.ImmutableEmptySortedMap;
import org.eclipse.collections.impl.map.sorted.immutable.ImmutableTreeMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;

@ServiceProvider(value=ImmutableSortedMapFactory.class)
public class ImmutableSortedMapFactoryImpl
implements ImmutableSortedMapFactory {
    public static final ImmutableSortedMapFactory INSTANCE = new ImmutableSortedMapFactoryImpl();

    public <K, V> ImmutableSortedMap<K, V> empty() {
        return ImmutableEmptySortedMap.INSTANCE;
    }

    public <K, V> ImmutableSortedMap<K, V> of() {
        return this.empty();
    }

    public <K, V> ImmutableSortedMap<K, V> with() {
        return this.empty();
    }

    public <K, V> ImmutableSortedMap<K, V> of(K key, V value) {
        return this.with(key, value);
    }

    public <K, V> ImmutableSortedMap<K, V> with(K key, V value) {
        return TreeSortedMap.newMapWith(key, value).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(K key1, V value1, K key2, V value2) {
        return this.with(key1, value1, key2, value2);
    }

    public <K, V> ImmutableSortedMap<K, V> with(K key1, V value1, K key2, V value2) {
        return TreeSortedMap.newMapWith(key1, value1, key2, value2).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return this.with(key1, value1, key2, value2, key3, value3);
    }

    public <K, V> ImmutableSortedMap<K, V> with(K key1, V value1, K key2, V value2, K key3, V value3) {
        return TreeSortedMap.newMapWith(key1, value1, key2, value2, key3, value3).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return this.with(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public <K, V> ImmutableSortedMap<K, V> with(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return TreeSortedMap.newMapWith(key1, value1, key2, value2, key3, value3, key4, value4).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator) {
        return this.with(comparator);
    }

    public <K, V> ImmutableSortedMap<K, V> with(Comparator<? super K> comparator) {
        if (comparator == null) {
            return this.of();
        }
        return new ImmutableEmptySortedMap(comparator);
    }

    public <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K key, V value) {
        return this.with(comparator, key, value);
    }

    public <K, V> ImmutableSortedMap<K, V> with(Comparator<? super K> comparator, K key, V value) {
        return TreeSortedMap.newMap(comparator).with(key, value).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K key1, V value1, K key2, V value2) {
        return this.with(comparator, key1, value1, key2, value2);
    }

    public <K, V> ImmutableSortedMap<K, V> with(Comparator<? super K> comparator, K key1, V value1, K key2, V value2) {
        return TreeSortedMap.newMap(comparator).with(key1, value1, key2, value2).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K key1, V value1, K key2, V value2, K key3, V value3) {
        return this.with(comparator, key1, value1, key2, value2, key3, value3);
    }

    public <K, V> ImmutableSortedMap<K, V> with(Comparator<? super K> comparator, K key1, V value1, K key2, V value2, K key3, V value3) {
        return TreeSortedMap.newMap(comparator).with(key1, value1, key2, value2, key3, value3).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return this.with(comparator, key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public <K, V> ImmutableSortedMap<K, V> with(Comparator<? super K> comparator, K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return TreeSortedMap.newMap(comparator).with(key1, value1, key2, value2, key3, value3, key4, value4).toImmutable();
    }

    public <K, V> ImmutableSortedMap<K, V> ofSortedMap(SortedMap<K, V> map) {
        return this.withSortedMap(map);
    }

    public <K, V> ImmutableSortedMap<K, V> withSortedMap(SortedMap<K, V> map) {
        if (map instanceof ImmutableSortedMap) {
            return (ImmutableSortedMap)map;
        }
        if (map.isEmpty()) {
            return this.of(map.comparator());
        }
        return ImmutableTreeMap.newMap(map);
    }
}

