/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameContextFactory;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementHandler;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringPreferences;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringController;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.ui.refactoring2.rename.ISimpleNameProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DefaultRenameElementHandler
extends AbstractHandler
implements IRenameElementHandler {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    protected RenameRefactoringController renameRefactoringController;
    @Inject
    protected IGlobalServiceProvider globalServiceProvider;
    @Inject
    protected RefactoringPreferences preferences;
    @Inject
    protected IRenameContextFactory renameContextFactory;
    @Inject
    protected SyncUtil syncUtil;
    protected static final Logger LOG = Logger.getLogger(DefaultRenameElementHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
            if (editor != null) {
                this.syncUtil.totalSync(this.preferences.isSaveAllBeforeRefactoring(), this.renameRefactoringController.getActiveLinkedMode() == null);
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IRenameElementContext renameElementContext = (IRenameElementContext)editor.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork<IRenameElementContext, XtextResource>(){

                    public IRenameElementContext exec(XtextResource resource) throws Exception {
                        IRenameElementContext renameElementContext;
                        EObject selectedElement = DefaultRenameElementHandler.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                        if (selectedElement != null && DefaultRenameElementHandler.this.isRefactoringEnabled(renameElementContext = DefaultRenameElementHandler.this.renameContextFactory.createRenameElementContext(selectedElement, editor, selection, resource), resource)) {
                            return renameElementContext;
                        }
                        return null;
                    }
                });
                if (renameElementContext != null) {
                    this.startRenameElement(renameElementContext);
                }
            }
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Exception exc) {
            LOG.error((Object)"Error initializing refactoring", (Throwable)exc);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error initializing refactoring", (String)(exc.getMessage() + "\nSee log for details"));
        }
        return null;
    }

    @Override
    public IRenameElementContext createRenameElementContext(EObject targetElement, XtextEditor triggeringEditor, ITextSelection selection, XtextResource triggeringResource) {
        return this.renameContextFactory.createRenameElementContext(targetElement, triggeringEditor, selection, triggeringResource);
    }

    protected boolean isRefactoringEnabled(IRenameElementContext renameElementContext, XtextResource resource) {
        EObject targetElement;
        ResourceSet resourceSet = resource.getResourceSet();
        if (renameElementContext != null && resourceSet != null && (targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true)) != null && !targetElement.eIsProxy()) {
            block5: {
                ITextRegion significantRegion;
                ITextSelection textSelection;
                TextRegion selectedRegion;
                INode crossReferenceNode;
                if (targetElement.eResource() == resource && renameElementContext.getTriggeringEditorSelection() instanceof ITextSelection && (crossReferenceNode = this.eObjectAtOffsetHelper.getCrossReferenceNode(resource, (ITextRegion)(selectedRegion = new TextRegion((textSelection = (ITextSelection)renameElementContext.getTriggeringEditorSelection()).getOffset(), textSelection.getLength())))) == null && !(significantRegion = this.locationInFileProvider.getSignificantTextRegion(targetElement)).contains((ITextRegion)selectedRegion)) {
                    return false;
                }
                IRenameStrategy.Provider renameStrategyProvider = (IRenameStrategy.Provider)this.globalServiceProvider.findService(targetElement, IRenameStrategy.Provider.class);
                if (renameStrategyProvider.get(targetElement, renameElementContext) == null) break block5;
                return true;
            }
            try {
                IRenameStrategy2 strategy2 = (IRenameStrategy2)this.globalServiceProvider.findService(targetElement, IRenameStrategy2.class);
                ISimpleNameProvider simpleNameProvider = (ISimpleNameProvider)this.globalServiceProvider.findService(targetElement, ISimpleNameProvider.class);
                return strategy2 != null && simpleNameProvider.canRename(targetElement);
            }
            catch (IRenameStrategy.Provider.NoSuchStrategyException e) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot rename element", (String)e.getMessage());
            }
        }
        return false;
    }

    protected void startRenameElement(IRenameElementContext renameElementContext) throws InterruptedException {
        this.renameRefactoringController.startRefactoring(renameElementContext);
    }
}

