/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing.util;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;

public class IResourcesSetupUtil {
    public static IWorkspaceRoot root() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IProject createProject(String name) throws CoreException, InvocationTargetException, InterruptedException {
        IProject project = IResourcesSetupUtil.root().getProject(name);
        IResourcesSetupUtil.createProject(project);
        return project;
    }

    public static IProject createProject(IProject project) throws CoreException {
        if (!project.exists()) {
            project.create(IResourcesSetupUtil.monitor());
        }
        project.open(IResourcesSetupUtil.monitor());
        return project;
    }

    public static void assertNoErrorsInWorkspace() throws CoreException {
        IMarker[] findMarkers = IResourcesSetupUtil.root().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        String msg = "";
        IMarker[] iMarkerArray = findMarkers;
        int n = findMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (MarkerUtilities.getSeverity((IMarker)iMarker) == 2) {
                msg = String.valueOf(msg) + "\n - " + iMarker.getResource().getName() + ":" + MarkerUtilities.getLineNumber((IMarker)iMarker) + " - " + MarkerUtilities.getMessage((IMarker)iMarker) + "(" + MarkerUtilities.getMarkerType((IMarker)iMarker) + ")";
            }
            ++n2;
        }
        if (msg.length() > 0) {
            Assert.fail((String)("Workspace contained errors: " + msg));
        }
    }

    public static void addNature(IProject project, String nature) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = nature;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static void addBuilder(IProject project, String builderId) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] specs = description.getBuildSpec();
        ICommand command = description.newCommand();
        command.setBuilderName(builderId);
        ICommand[] specsModified = new ICommand[specs.length + 1];
        System.arraycopy(specs, 0, specsModified, 0, specs.length);
        specsModified[specs.length] = command;
        description.setBuildSpec(specsModified);
        project.setDescription(description, IResourcesSetupUtil.monitor());
    }

    public static void removeNature(IProject project, String nature) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (nature.equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public static void removeBuilder(IProject project, String builderId) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] builderSpecs = description.getBuildSpec();
        int i = 0;
        while (i < builderSpecs.length) {
            if (builderId.equals(builderSpecs[i].getBuilderName())) {
                ICommand[] modifiedSpecs = new ICommand[builderSpecs.length - 1];
                System.arraycopy(builderSpecs, 0, modifiedSpecs, 0, i);
                System.arraycopy(builderSpecs, i + 1, modifiedSpecs, i, builderSpecs.length - i - 1);
                description.setBuildSpec(modifiedSpecs);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public static void setReference(final IProject from, final IProject to) throws CoreException, InvocationTargetException, InterruptedException {
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription projectDescription = from.getDescription();
                IProject[] projects = projectDescription.getReferencedProjects();
                IProject[] newProjects = new IProject[projects.length + 1];
                System.arraycopy(projects, 0, newProjects, 0, projects.length);
                newProjects[projects.length] = to;
                projectDescription.setReferencedProjects(newProjects);
                from.setDescription(projectDescription, IResourcesSetupUtil.monitor());
            }
        }.run(IResourcesSetupUtil.monitor());
    }

    public static void removeReference(final IProject from, final IProject to) throws CoreException, InvocationTargetException, InterruptedException {
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription projectDescription = from.getDescription();
                IProject[] projects = projectDescription.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    if (to.equals((Object)projects[i])) {
                        IProject[] newProjects = new IProject[projects.length - 1];
                        System.arraycopy(projects, 0, newProjects, 0, i);
                        System.arraycopy(projects, i + 1, newProjects, i, projects.length - i - 1);
                        projectDescription.setReferencedProjects(newProjects);
                        from.setDescription(projectDescription, null);
                        return;
                    }
                    ++i;
                }
            }
        }.run(IResourcesSetupUtil.monitor());
    }

    public static IFolder createFolder(String wsRelativePath) throws InvocationTargetException, InterruptedException {
        return IResourcesSetupUtil.createFolder((IPath)new Path(wsRelativePath));
    }

    public static IFolder createFolder(IPath wsRelativePath) throws InvocationTargetException, InterruptedException {
        final IFolder folder = IResourcesSetupUtil.root().getFolder(wsRelativePath);
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IResourcesSetupUtil.create(folder.getParent());
                folder.delete(true, IResourcesSetupUtil.monitor());
                folder.create(true, true, IResourcesSetupUtil.monitor());
            }
        }.run(IResourcesSetupUtil.monitor());
        return folder;
    }

    public static IFile createFile(String projectName, String fileName, String fileExtension, String content) throws CoreException, InvocationTargetException, InterruptedException {
        return IResourcesSetupUtil.createFile(String.valueOf(projectName) + "/" + fileName + "." + fileExtension, content);
    }

    public static IFile createFile(String wsRelativePath, String s) throws CoreException, InvocationTargetException, InterruptedException {
        return IResourcesSetupUtil.createFile((IPath)new Path(wsRelativePath), s);
    }

    public static IFile createFile(IPath wsRelativePath, final String s) throws CoreException, InvocationTargetException, InterruptedException {
        final IFile file = IResourcesSetupUtil.root().getFile(wsRelativePath);
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IResourcesSetupUtil.create(file.getParent());
                file.delete(true, IResourcesSetupUtil.monitor());
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (StringInputStream stream = new StringInputStream(s, file.getCharset(true));){
                        file.create((InputStream)stream, true, IResourcesSetupUtil.monitor());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException exc) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.xtext.ui.testing", exc.getMessage(), (Throwable)exc));
                }
            }
        }.run(IResourcesSetupUtil.monitor());
        return file;
    }

    public static File createTempFile(String fileName, String suffix, String content) throws Exception {
        File file = File.createTempFile(fileName, suffix);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    public static IResource file(String path) {
        return IResourcesSetupUtil.root().findMember((IPath)new Path(path));
    }

    public static byte[] fileToByteArray(IFile file) throws CoreException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream contents = file.getContents();){
            return ByteStreams.toByteArray((InputStream)contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String fileToString(IFile file) throws CoreException, IOException {
        return new String(IResourcesSetupUtil.fileToByteArray(file), file.getCharset());
    }

    public static boolean fileIsEmpty(IFile file) throws IOException, CoreException {
        try (InputStream contents = null;){
            contents = file.getContents();
            boolean bl = contents.read() == -1;
            return bl;
        }
    }

    private static void create(final IContainer container) throws CoreException, InvocationTargetException, InterruptedException {
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (!container.exists()) {
                    IResourcesSetupUtil.create(container.getParent());
                    if (container instanceof IFolder) {
                        ((IFolder)container).create(true, true, IResourcesSetupUtil.monitor());
                    } else {
                        IProject iProject = (IProject)container;
                        IResourcesSetupUtil.createProject(iProject);
                    }
                }
            }
        }.run(IResourcesSetupUtil.monitor());
    }

    public static IProgressMonitor monitor() {
        return new NullProgressMonitor();
    }

    public static void fullBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, IResourcesSetupUtil.monitor());
    }

    public static void cleanBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(15, IResourcesSetupUtil.monitor());
    }

    @Deprecated
    public static void waitForAutoBuild() {
        IResourcesSetupUtil.reallyWaitForAutoBuild();
    }

    public static void reallyWaitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void waitForBuild() {
        IResourcesSetupUtil.waitForBuild(null);
    }

    public static boolean isAutobuild(boolean enable) {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    public static boolean setAutobuild(boolean enable) {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        boolean oldValue = description.isAutoBuilding();
        if (oldValue != enable) {
            description.setAutoBuilding(enable);
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                Exceptions.sneakyThrow((Throwable)e);
            }
        }
        return oldValue;
    }

    public static void waitForBuild(IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().build(10, monitor);
        }
        catch (CoreException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    public static void cleanWorkspace() throws CoreException {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IProject[] visibleProjects = IResourcesSetupUtil.root().getProjects();
                    IResourcesSetupUtil.deleteProjects(visibleProjects);
                    IProject[] hiddenProjects = IResourcesSetupUtil.root().getProjects(8);
                    IResourcesSetupUtil.deleteProjects(hiddenProjects);
                }
            }.run(IResourcesSetupUtil.monitor());
        }
        catch (InvocationTargetException e) {
            Exceptions.sneakyThrow((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected static void deleteProjects(IProject[] projects) throws CoreException {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.exists()) {
                iProject.delete(true, true, IResourcesSetupUtil.monitor());
            }
            ++n2;
        }
    }

    public static String printMarker(IMarker[] markers) throws CoreException {
        StringBuilder result = new StringBuilder();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(marker.getAttribute("message"));
            ++n2;
        }
        return result.toString();
    }
}

