/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.launcher;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.xtext.launcher.SelectionUtil;

public class WorkflowLaunchUtils {
    protected static final String MWE2_FILE_EXTENSION = "mwe2";
    protected static final String MWE2_LAUNCH_SHORCUT_ID = "org.eclipse.emf.mwe2.launch.shortcut1";
    protected static final Logger logger = Logger.getLogger(WorkflowLaunchUtils.class);
    private static final boolean mwe2Available;

    static {
        boolean b = true;
        try {
            Class.forName("org.eclipse.emf.mwe2.launch.runtime.Mwe2Launcher", false, WorkflowLaunchUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            b = false;
        }
        mwe2Available = b;
    }

    public static IResource workflowFileFor(ExecutionEvent event) {
        IFile file = SelectionUtil.getSelectedFile(event);
        return WorkflowLaunchUtils.workflowFileFor((IResource)file);
    }

    public static boolean workflowFileAvailableFor(IEditorPart activeEditor) {
        return WorkflowLaunchUtils.workflowFileFor(activeEditor) != null;
    }

    public static IResource workflowFileFor(IEditorPart editor) {
        IFile file = SelectionUtil.getSelectedFile(editor);
        return WorkflowLaunchUtils.workflowFileFor((IResource)file);
    }

    public static IResource workflowFileFor(ISelection selection) {
        IFile file = SelectionUtil.getSelectedFile(selection);
        return WorkflowLaunchUtils.workflowFileFor((IResource)file);
    }

    public static boolean workflowFileAvailableForGrammarFile(IResource resource) {
        return mwe2Available && WorkflowLaunchUtils.workflowFileFor(resource) != null;
    }

    public static IResource workflowFileFor(IResource resource) {
        IContainer parent = resource.getParent();
        IPath locationWithoutFileExtension = parent.getProjectRelativePath().append("Generate" + resource.getName()).removeFileExtension();
        IResource workflowFile = resource.getProject().findMember(locationWithoutFileExtension.addFileExtension(MWE2_FILE_EXTENSION));
        return workflowFile;
    }

    protected static ILaunchShortcut findLaunchShortcut() throws CoreException {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            Object executableExtension;
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute("id");
            if (id.equals(MWE2_LAUNCH_SHORCUT_ID) && (executableExtension = configurationElement.createExecutableExtension("class")) instanceof ILaunchShortcut) {
                ILaunchShortcut launchShortcut = (ILaunchShortcut)executableExtension;
                return launchShortcut;
            }
            ++n2;
        }
        return null;
    }

    public static void runWorkflow(IResource workflowFile, String mode) {
        try {
            ILaunchShortcut launchShortcut = WorkflowLaunchUtils.findLaunchShortcut();
            if (launchShortcut != null) {
                StructuredSelection selection = new StructuredSelection((Object)workflowFile);
                launchShortcut.launch((ISelection)selection, mode);
            }
        }
        catch (CoreException e) {
            logger.error((Object)"Could not delegate to MWE2 launch shortcut.", (Throwable)e);
            e.printStackTrace();
        }
    }
}

