/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.xtext.validation.AbstractValidationDiagnostic;

public class AssertableDiagnostics {
    protected Diagnostic diag;

    public static Pred diagnostic(Integer severity, String issueCode, String messageFragment) {
        return new Pred(severity, null, issueCode, messageFragment);
    }

    public static Pred diagnostic(Integer severity, Integer code, String messageFragment) {
        return new Pred(severity, code, null, messageFragment);
    }

    public static Pred diagnostic(Integer severity, Integer code, String issueCode, String messageFragment) {
        return new Pred(severity, code, issueCode, messageFragment);
    }

    public static Pred errorCode(String code) {
        return new Pred(4, null, code, null);
    }

    public static Pred errorCode(int code) {
        return new Pred(4, code, null, null);
    }

    public static Pred error(String code, String messageFragment) {
        return new Pred(4, null, code, messageFragment);
    }

    public static Pred error(int code, String messageFragment) {
        return new Pred(4, code, null, messageFragment);
    }

    public static Pred errorMsg(String messageFragment) {
        return new Pred(4, null, null, messageFragment);
    }

    public static Pred warningCode(String code) {
        return new Pred(2, null, code, null);
    }

    public static Pred warningCode(int code) {
        return new Pred(2, code, null, null);
    }

    public static Pred warning(String code, String messageFragment) {
        return new Pred(2, null, code, messageFragment);
    }

    public static Pred warning(int code, String messageFragment) {
        return new Pred(2, code, null, messageFragment);
    }

    public static Pred warningMsg(String messageFragment) {
        return new Pred(2, null, null, messageFragment);
    }

    public AssertableDiagnostics(Diagnostic diag) {
        this.diag = diag;
    }

    public void assertAll(DiagnosticPredicate ... predicates) {
        HashMap<DiagnosticPredicate, Boolean> consumed = new HashMap<DiagnosticPredicate, Boolean>();
        DiagnosticPredicate[] diagnosticPredicateArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            DiagnosticPredicate p = diagnosticPredicateArray[n2];
            consumed.put(p, Boolean.FALSE);
            ++n2;
        }
        for (Diagnostic d : this.getAllDiagnostics()) {
            boolean found = false;
            for (Map.Entry e : consumed.entrySet()) {
                if (((Boolean)e.getValue()).booleanValue() || !((DiagnosticPredicate)e.getKey()).apply(d)) continue;
                consumed.put((DiagnosticPredicate)e.getKey(), Boolean.TRUE);
                found = true;
                break;
            }
            if (found) continue;
            if (predicates.length == 1) {
                this.fail("Predicate " + predicates[0] + " does not match " + d);
                continue;
            }
            this.fail("No predicate in " + Arrays.toString(predicates) + " matches " + d);
        }
        ArrayList<DiagnosticPredicate> unconsumed = new ArrayList<DiagnosticPredicate>();
        for (Map.Entry e : consumed.entrySet()) {
            if (((Boolean)e.getValue()).booleanValue()) continue;
            unconsumed.add((DiagnosticPredicate)e.getKey());
        }
        if (unconsumed.size() != 0) {
            this.fail("There are diagnostics missing for theses predicates: " + unconsumed);
        }
    }

    public AssertableDiagnostics assertAny(DiagnosticPredicate ... predicates) {
        DiagnosticPredicate[] diagnosticPredicateArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            DiagnosticPredicate predicate = diagnosticPredicateArray[n2];
            if (Iterables.any(this.getAllDiagnostics(), (Predicate)predicate)) {
                return this;
            }
            ++n2;
        }
        this.fail("predicate not found");
        return this;
    }

    public void assertDiagnostic(Integer severity, String issueCode, String messageFragment) {
        this.assertAll(AssertableDiagnostics.diagnostic(severity, issueCode, messageFragment));
    }

    public void assertDiagnostic(Integer severity, int code, String issueCode, String messageFragment) {
        this.assertAll(AssertableDiagnostics.diagnostic(severity, code, issueCode, messageFragment));
    }

    public void assertDiagnostic(Integer severity, int code, String messageFragment) {
        this.assertAll(AssertableDiagnostics.diagnostic(severity, code, messageFragment));
    }

    public AssertableDiagnostics assertDiagnosticsCount(int size) {
        int count = Iterables.size(this.getAllDiagnostics());
        if (count == size) {
            return this;
        }
        this.fail("There are " + count + " diagnostics, but " + size + " are expected.");
        return this;
    }

    public void assertError(String issueCode) {
        this.assertAll(AssertableDiagnostics.errorCode(issueCode));
    }

    public void assertError(int code) {
        this.assertAll(AssertableDiagnostics.errorCode(code));
    }

    public void assertError(String issueCode, String messageFragment) {
        this.assertAll(AssertableDiagnostics.error(issueCode, messageFragment));
    }

    public void assertError(int code, String messageFragment) {
        this.assertAll(AssertableDiagnostics.error(code, messageFragment));
    }

    public void assertErrorContains(String messageFragment) {
        this.assertAll(AssertableDiagnostics.errorMsg(messageFragment));
    }

    public void assertOK() {
        if (this.diag.getChildren().size() != 0) {
            this.fail("There are expected to be no diagnostics.");
        }
    }

    public void assertWarning(String issueCode) {
        this.assertAll(AssertableDiagnostics.warningCode(issueCode));
    }

    public void assertWarning(int code) {
        this.assertAll(AssertableDiagnostics.warningCode(code));
    }

    public void assertWarning(String code, String messageFragment) {
        this.assertAll(AssertableDiagnostics.warning(code, messageFragment));
    }

    public void assertWarning(int code, String messageFragment) {
        this.assertAll(AssertableDiagnostics.warning(code, messageFragment));
    }

    public void assertWarningContains(String messageFragment) {
        this.assertAll(AssertableDiagnostics.warningMsg(messageFragment));
    }

    public void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public Iterable<Diagnostic> getAllDiagnostics() {
        return new DiagnosticTreeIterator(this.diag);
    }

    public Diagnostic getDiagnostic() {
        return this.diag;
    }

    protected void printDiagnostic(StringBuffer out, String prefix, Diagnostic d) {
        out.append(prefix);
        out.append(d);
        if (d.getChildren().size() > 0 || d.getException() != null) {
            out.append(" {\n");
            String prefix2 = String.valueOf(prefix) + "  ";
            if (d.getException() != null) {
                out.append(prefix2);
                ByteArrayOutputStream s = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(s);
                d.getException().printStackTrace(pw);
                pw.flush();
                out.append(s.toString());
                out.append("\n");
            }
            for (Diagnostic c : d.getChildren()) {
                this.printDiagnostic(out, prefix2, c);
            }
            out.append(prefix);
            out.append("}\n");
        } else {
            out.append("\n");
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (Diagnostic d : this.diag.getChildren()) {
            this.printDiagnostic(b, "", d);
        }
        return b.toString();
    }

    public static interface DiagnosticPredicate
    extends Predicate<Diagnostic> {
    }

    protected class DiagnosticTreeIterator
    implements Iterable<Diagnostic>,
    Iterator<Diagnostic> {
        private ArrayList<Iterator<Diagnostic>> iteratorStack = new ArrayList();

        public DiagnosticTreeIterator(Diagnostic root) {
            this.iteratorStack.add(root.getChildren().iterator());
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorStack.size() > 0 && !this.iteratorStack.get(this.iteratorStack.size() - 1).hasNext()) {
                this.iteratorStack.remove(this.iteratorStack.size() - 1);
            }
            return this.iteratorStack.size() != 0;
        }

        @Override
        public Iterator<Diagnostic> iterator() {
            return this;
        }

        @Override
        public Diagnostic next() {
            Diagnostic d = this.iteratorStack.get(this.iteratorStack.size() - 1).next();
            if (d.getChildren().size() > 0) {
                this.iteratorStack.add(d.getChildren().iterator());
            }
            return d;
        }

        @Override
        public void remove() {
            throw new RuntimeException("operation not supported");
        }
    }

    public static class Pred
    implements DiagnosticPredicate {
        protected String issueCode;
        protected String msg;
        protected Integer severity;
        protected Integer code;

        public Pred(Integer severity, Integer code, String issueCode, String msg) {
            this.severity = severity;
            this.code = code;
            this.issueCode = issueCode;
            this.msg = msg;
        }

        public boolean apply(Diagnostic d) {
            if (this.severity != null && d.getSeverity() != this.severity.intValue()) {
                return false;
            }
            if (this.code != null && !this.code.equals(d.getCode())) {
                return false;
            }
            if (this.issueCode != null && d instanceof AbstractValidationDiagnostic && !((AbstractValidationDiagnostic)d).getIssueCode().equals(this.issueCode)) {
                return false;
            }
            return this.msg == null || d.getMessage() == null || d.getMessage().contains(this.msg);
        }

        public String toString() {
            ArrayList<String> r = new ArrayList<String>();
            if (this.severity != null) {
                r.add(AbstractValidationDiagnostic.severityToStr((int)this.severity));
            }
            if (this.issueCode != null) {
                r.add("issueCode=" + this.issueCode);
            }
            if (this.code != null) {
                r.add("code=" + this.code);
            }
            if (this.msg != null) {
                r.add("msgFragment='" + this.msg + "'");
            }
            return "(" + Joiner.on((String)" ").join(r) + ")";
        }
    }
}

