/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.impl.BuildManagerAccess;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.SourceLevelURICache;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.Strings;

public class BuildData {
    private final ToBeBuilt toBeBuilt;
    private final QueuedBuildData queuedBuildData;
    private final String projectName;
    private final ImmutableSet<String> removedProjects;
    private final ResourceSet resourceSet;
    private final boolean indexingOnly;
    private final SourceLevelURICache sourceLevelURICache;
    private final Runnable buildRequestor;

    public BuildData(String projectName, ResourceSet resourceSet, ToBeBuilt toBeBuilt, QueuedBuildData queuedBuildData) {
        this(projectName, resourceSet, toBeBuilt, queuedBuildData, false);
    }

    public BuildData(String projectName, ResourceSet resourceSet, ToBeBuilt toBeBuilt, QueuedBuildData queuedBuildData, boolean indexingOnly) {
        this(projectName, resourceSet, toBeBuilt, queuedBuildData, indexingOnly, BuildManagerAccess::requestBuild);
    }

    public BuildData(String projectName, ResourceSet resourceSet, ToBeBuilt toBeBuilt, QueuedBuildData queuedBuildData, boolean indexingOnly, Runnable buildRequestor) {
        this(projectName, resourceSet, toBeBuilt, queuedBuildData, indexingOnly, buildRequestor, (Set<String>)ImmutableSet.of());
    }

    public BuildData(String projectName, ResourceSet resourceSet, ToBeBuilt toBeBuilt, QueuedBuildData queuedBuildData, boolean indexingOnly, Runnable buildRequestor, Set<String> removedProjects) {
        this.projectName = Strings.emptyIfNull((String)projectName);
        this.removedProjects = ImmutableSet.copyOf(removedProjects);
        this.resourceSet = resourceSet;
        this.toBeBuilt = toBeBuilt;
        this.queuedBuildData = queuedBuildData;
        this.indexingOnly = indexingOnly;
        this.sourceLevelURICache = new SourceLevelURICache();
        this.buildRequestor = buildRequestor;
    }

    public boolean isEmpty() {
        return this.getToBeDeleted().isEmpty() && this.getToBeUpdated().isEmpty() && this.queuedBuildData.isEmpty(this.projectName);
    }

    public boolean isIndexingOnly() {
        return this.indexingOnly;
    }

    public Set<URI> getToBeDeleted() {
        return this.toBeBuilt.getToBeDeleted();
    }

    public Set<URI> getToBeUpdated() {
        return this.toBeBuilt.getToBeUpdated();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Set<URI> getAndRemoveToBeDeleted() {
        Set<URI> result = this.toBeBuilt.getAndRemoveToBeDeleted();
        return result;
    }

    public void queueURI(URI uri) {
        this.queuedBuildData.queueURI(uri);
    }

    public Collection<IResourceDescription.Delta> getAndRemovePendingDeltas() {
        return this.queuedBuildData.getAndRemovePendingDeltas();
    }

    public Queue<URI> getURIQueue() {
        return this.queuedBuildData.getQueue(this.projectName);
    }

    public Iterable<URI> getAllRemainingURIs() {
        return this.queuedBuildData.getAllRemainingURIs();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ImmutableSet<String> getParticipatingProjects() {
        if (Strings.isEmpty((String)this.projectName)) {
            return this.removedProjects;
        }
        return ImmutableSet.builder().add((Object)this.projectName).addAll(this.removedProjects).build();
    }

    public ImmutableSet<String> getRemovedProjects() {
        return this.removedProjects;
    }

    public SourceLevelURICache getSourceLevelURICache() {
        return this.sourceLevelURICache;
    }

    public void requestRebuild() {
        this.buildRequestor.run();
    }
}

