/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.util.TypeUtil;

public class OperationMatcher {
    private OperationMatcher() {
    }

    public static boolean matchOperation(QvtOperationalEnv env, ImperativeOperation imperativeOp, EOperation libraryOp) {
        if (!libraryOp.getName().equals(imperativeOp.getName())) {
            return false;
        }
        EClassifier contextType = QvtOperationalParserUtil.getContextualType(imperativeOp);
        EClassifier owner = (EClassifier)env.getUMLReflection().getOwningClassifier((Object)libraryOp);
        if (contextType == null ? !(owner instanceof Library) : !TypeUtil.exactTypeMatch((Environment)env, (Object)contextType, (Object)owner)) {
            return false;
        }
        if (imperativeOp.getEParameters().size() != libraryOp.getEParameters().size()) {
            return false;
        }
        int i = 0;
        int in = imperativeOp.getEParameters().size();
        while (i < in) {
            if (!TypeUtil.exactTypeMatch((Environment)env, (Object)((EParameter)imperativeOp.getEParameters().get(i)).getEType(), (Object)((EParameter)libraryOp.getEParameters().get(i)).getEType())) {
                return false;
            }
            ++i;
        }
        return !(imperativeOp.getResult().size() == 0 ? libraryOp.getEType() != env.getOCLStandardLibrary().getOclVoid() : !TypeUtil.exactTypeMatch((Environment)env, (Object)libraryOp.getEType(), (Object)((VarParameter)imperativeOp.getResult().get(0)).getEType()));
    }

    public static boolean matchOperation(QvtOperationalEnv env, OperationalTransformation trans, EOperation libraryOp) {
        if (!libraryOp.getName().equals(trans.getName())) {
            return false;
        }
        List<ETypedElement> expectedParams = EvaluationUtil.getBlackboxSignature(trans);
        if (expectedParams.size() != libraryOp.getEParameters().size()) {
            return false;
        }
        int i = 0;
        int in = expectedParams.size();
        while (i < in) {
            if (!TypeUtil.compatibleTypeMatch((Environment)env, (Object)expectedParams.get(i).getEType(), (Object)((EParameter)libraryOp.getEParameters().get(i)).getEType())) {
                return false;
            }
            ++i;
        }
        return libraryOp.getEType() == env.getOCLStandardLibrary().getOclVoid();
    }
}

