/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.StandaloneBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackboxRegistry {
    private static final String CLASS_ATTR = "class";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String BLACKBOX_PROVIDER_EXTENSION = "blackboxProvider";
    public static BlackboxRegistry INSTANCE = new BlackboxRegistry();
    private List<? extends AbstractBlackboxProvider> fProviders;

    private BlackboxRegistry() {
        try {
            this.fProviders = EMFPlugin.IS_ECLIPSE_RUNNING ? Eclipse.readProviders() : Arrays.asList(new StandaloneBlackboxProvider());
        }
        catch (RuntimeException e) {
            this.fProviders = Collections.emptyList();
            QvtPlugin.error(e);
        }
    }

    public AbstractCompilationUnitDescriptor getCompilationUnitDescriptor(String qualifiedName, ResolutionContext context) {
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.fProviders) {
            AbstractCompilationUnitDescriptor descriptor = abstractBlackboxProvider.getModuleDescriptor(qualifiedName, context);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor descriptor, LoadContext loadContext) throws BlackboxException {
        if (descriptor == null) {
            throw new IllegalArgumentException("Null blackbox descriptor");
        }
        AbstractBlackboxProvider provider = descriptor.getProvider();
        return provider.loadCompilationUnit(descriptor, loadContext);
    }

    public List<AbstractCompilationUnitDescriptor> getCompilationUnitDescriptors(ResolutionContext loadContext) {
        ArrayList<AbstractCompilationUnitDescriptor> result = new ArrayList<AbstractCompilationUnitDescriptor>();
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.fProviders) {
            for (AbstractCompilationUnitDescriptor abstractCompilationUnitDescriptor : abstractBlackboxProvider.getModuleDescriptors(loadContext)) {
                result.add(abstractCompilationUnitDescriptor);
            }
        }
        return result;
    }

    public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation operation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.fProviders) {
            Collection<CallHandler> handlers = abstractBlackboxProvider.getBlackboxCallHandler(operation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation transformation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.fProviders) {
            Collection<CallHandler> handlers = abstractBlackboxProvider.getBlackboxCallHandler(transformation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Eclipse {
        private Eclipse() {
        }

        private static List<AbstractBlackboxProvider> readProviders() {
            IConfigurationElement[] configs;
            LinkedList<AbstractBlackboxProvider> providers = new LinkedList<AbstractBlackboxProvider>();
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", BlackboxRegistry.BLACKBOX_PROVIDER_EXTENSION);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(BlackboxRegistry.PROVIDER_ELEMENT)) {
                    try {
                        Object extension = element.createExecutableExtension(BlackboxRegistry.CLASS_ATTR);
                        if (!(extension instanceof AbstractBlackboxProvider)) {
                            QvtPlugin.error("Provider must implement AbstractBlackboxProvider interface: " + extension);
                        } else {
                            providers.add((AbstractBlackboxProvider)extension);
                        }
                    }
                    catch (CoreException e) {
                        QvtPlugin.getDefault().log(e.getStatus());
                    }
                }
                ++n2;
            }
            return providers;
        }
    }
}

