/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.internal.qvt.oml.stdlib.MutableListImpl;
import org.eclipse.m2m.qvt.oml.util.Dictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryImpl<KeyT, T>
implements Dictionary<KeyT, T> {
    private final Map<KeyT, T> fMap;

    public DictionaryImpl() {
        this.fMap = new HashMap<KeyT, T>();
    }

    public DictionaryImpl(DictionaryImpl<KeyT, T> source) {
        this.fMap = new HashMap<KeyT, T>(source.fMap);
    }

    @Override
    public T get(KeyT k) {
        return this.fMap.get(k);
    }

    @Override
    public void put(KeyT k, T v) {
        this.fMap.put(k, v);
    }

    @Override
    public boolean hasKey(KeyT k) {
        return this.fMap.containsKey(k);
    }

    @Override
    public T defaultget(KeyT k, T v) {
        return this.fMap.containsKey(k) ? this.fMap.get(k) : v;
    }

    @Override
    public void clear() {
        this.fMap.clear();
    }

    @Override
    public int size() {
        return this.fMap.size();
    }

    @Override
    public List<KeyT> keys() {
        return new MutableListImpl<KeyT>(this.fMap.keySet());
    }

    @Override
    public List<T> values() {
        return new MutableListImpl<T>(this.fMap.values());
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c instanceof DictionaryImpl) {
            DictionaryImpl anotherDict = (DictionaryImpl)c;
            this.fMap.putAll(anotherDict.fMap);
        } else {
            for (T o : c) {
                this.add(o);
            }
        }
        return true;
    }

    @Override
    public boolean add(T o) {
        boolean canAdd;
        boolean bl = this.fMap.containsKey(null) ? this.fMap.get(null) != o : (canAdd = true);
        if (canAdd) {
            this.put(null, o);
        }
        return canAdd;
    }

    @Override
    public boolean contains(Object o) {
        return this.fMap.containsValue(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.fMap.values().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.fMap.values().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.fMap.values().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.fMap.values().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.fMap.values().retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.fMap.values().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.fMap.values().toArray(a);
    }

    public String toString() {
        return "Dict" + this.fMap.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictionaryImpl)) {
            return false;
        }
        return this.fMap.equals(((DictionaryImpl)o).fMap);
    }

    @Override
    public int hashCode() {
        return this.fMap.hashCode();
    }
}

