/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingExtensionKindCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingExtensionHelper {
    MappingExtensionHelper() {
    }

    private static ExtensionSourceRefAdapter attachSourceRefAdapter(MappingOperation mapping) {
        ExtensionSourceRefAdapter adapter = new ExtensionSourceRefAdapter();
        mapping.eAdapters().add((Object)adapter);
        return adapter;
    }

    public static void bind2SourceElement(MappingOperation extendedOperation, CSTNode sourceRefElement, MappingExtensionKindCS extensionKindCS) {
        ExtensionSourceRefAdapter adapter = MappingExtensionHelper.getSourceRefAdapter(extendedOperation);
        if (adapter == null) {
            adapter = MappingExtensionHelper.attachSourceRefAdapter(extendedOperation);
        }
        if (extensionKindCS == MappingExtensionKindCS.INHERITS) {
            adapter.addInherit(extendedOperation, sourceRefElement);
        } else if (extensionKindCS == MappingExtensionKindCS.DISJUNCTS) {
            adapter.addDisjunct(extendedOperation, sourceRefElement);
        } else if (extensionKindCS == MappingExtensionKindCS.MERGES) {
            adapter.addMerge(extendedOperation, sourceRefElement);
        } else assert (false) : "Uknown extension kind";
    }

    private static ExtensionSourceRefAdapter getSourceRefAdapter(MappingOperation mapping) {
        return (ExtensionSourceRefAdapter)EcoreUtil.getExistingAdapter((Notifier)mapping, ExtensionSourceRefAdapter.class);
    }

    public static boolean validate(MappingOperation operation, QvtOperationalEnv env) {
        boolean isValid = true;
        if (!operation.getInherited().isEmpty()) {
            isValid &= new ExtensionValidator(operation, (List)operation.getInherited(), MappingExtensionKindCS.INHERITS){

                @Override
                List<MappingSourceReference> getMappingSourceRefs() {
                    return this.getSrcAdapter().getInheritReferences();
                }

                @Override
                boolean isConformantForExtension(MappingOperation extendingOper, MappingOperation extendedOper, QvtOperationalEnv env) {
                    return MappingExtensionHelper.isInheritCompatible(extendingOper, extendedOper, env);
                }
            }.validate(env);
        }
        if (!operation.getDisjunct().isEmpty()) {
            isValid &= new DisjunctValidator(operation, (List)operation.getDisjunct(), MappingExtensionKindCS.DISJUNCTS).validate(env);
        }
        if (!operation.getMerged().isEmpty()) {
            isValid &= new ExtensionValidator(operation, (List)operation.getMerged(), MappingExtensionKindCS.MERGES){

                @Override
                List<MappingSourceReference> getMappingSourceRefs() {
                    return this.getSrcAdapter().getMergeReferences();
                }

                @Override
                boolean isConformantForExtension(MappingOperation extendingOper, MappingOperation extendedOper, QvtOperationalEnv env) {
                    return MappingExtensionHelper.isMergeCompatible(extendingOper, extendedOper, env);
                }
            }.validate(env);
        }
        return isValid;
    }

    public static boolean isMergeCompatible(MappingOperation mergingOperation, MappingOperation mergedOperation, QvtOperationalEnv env) {
        return MappingExtensionHelper.isCaller2CalleeCompatible(mergedOperation, mergingOperation, env);
    }

    public static boolean isDisjunctCompatible(MappingOperation disjunctingOperation, MappingOperation disjunctedOperation, QvtOperationalEnv env) {
        return MappingExtensionHelper.isCaller2CalleeCompatible(disjunctingOperation, disjunctedOperation, env);
    }

    public static boolean isInheritCompatible(MappingOperation inheritingOperation, MappingOperation intheritedOperation, QvtOperationalEnv env) {
        return MappingExtensionHelper.isCaller2CalleeCompatible(intheritedOperation, inheritingOperation, env);
    }

    public static Collection<MappingOperation> checkForExtensionCycle(MappingOperation extendingOperation) {
        return Collections.emptyList();
    }

    static boolean isCaller2CalleeCompatible(MappingOperation extendingOper, MappingOperation extendedOper, QvtOperationalEnv env) {
        if (extendingOper.getEParameters().size() != extendedOper.getEParameters().size()) {
            return false;
        }
        EClassifier ctx1 = QvtOperationalParserUtil.getContextualType(extendingOper);
        EClassifier ctx2 = QvtOperationalParserUtil.getContextualType(extendedOper);
        if (ctx1 == null || ctx2 == null ? ctx1 != ctx2 : !MappingExtensionHelper.isAssignableTo(ctx2, ctx1, env)) {
            return false;
        }
        if (!MappingExtensionHelper.isParameterListCaller2CalleeCompatible((EList<? extends EParameter>)extendingOper.getEParameters(), (EList<? extends EParameter>)extendedOper.getEParameters(), env)) {
            return false;
        }
        if (!MappingExtensionHelper.isParameterListCaller2CalleeCompatible(extendingOper.getResult(), extendedOper.getResult(), env)) {
            return false;
        }
        if (extendingOper.getEType() == null || extendedOper.getEType() == null) {
            return false;
        }
        return extendingOper.getResult().size() == 1 || MappingExtensionHelper.isAssignableTo(extendingOper.getEType(), extendedOper.getEType(), env);
    }

    private static boolean isParameterListCaller2CalleeCompatible(EList<? extends EParameter> callerParams, EList<? extends EParameter> calleeParams, QvtOperationalEnv env) {
        if (callerParams.size() != calleeParams.size()) {
            return false;
        }
        int i = 0;
        while (i < calleeParams.size()) {
            EParameter callerPar = (EParameter)callerParams.get(i);
            EParameter calleePar = (EParameter)calleeParams.get(i);
            boolean isAssignable = MappingExtensionHelper.isAssignableTo(calleePar.getEType(), callerPar.getEType(), env);
            boolean isDirectionOK = true;
            if (calleePar instanceof VarParameter) {
                if (callerPar instanceof VarParameter) {
                    isDirectionOK = MappingExtensionHelper.isDirectionKindCaller2CalleeCompatible(((VarParameter)callerPar).getKind(), ((VarParameter)calleePar).getKind());
                } else {
                    return false;
                }
            }
            if (!isAssignable || !isDirectionOK) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isDirectionKindCaller2CalleeCompatible(DirectionKind callerKind, DirectionKind calleeKind) {
        if (callerKind == calleeKind) {
            return true;
        }
        if (callerKind == DirectionKind.IN) {
            return calleeKind == DirectionKind.INOUT || calleeKind == DirectionKind.IN;
        }
        if (callerKind == DirectionKind.INOUT) {
            return calleeKind == DirectionKind.INOUT;
        }
        return false;
    }

    private static boolean isAssignableTo(EClassifier sourceType, EClassifier targetType, QvtOperationalEnv env) {
        return (TypeUtil.getRelationship((Environment)env, (Object)sourceType, (Object)targetType) & 3) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DisjunctValidator
    extends ExtensionValidator {
        private DisjunctValidator(MappingOperation operation, List<MappingOperation> extendedOperations, MappingExtensionKindCS extensionKind) {
            super(operation, extendedOperations, extensionKind);
        }

        @Override
        List<MappingSourceReference> getMappingSourceRefs() {
            return this.getSrcAdapter().getDisjunctReferences();
        }

        @Override
        boolean isConformantForExtension(MappingOperation extendingOper, MappingOperation extendedOper, QvtOperationalEnv env) {
            return MappingExtensionHelper.isDisjunctCompatible(extendingOper, extendedOper, env);
        }

        @Override
        boolean validate(QvtOperationalEnv env) {
            boolean result = true;
            MappingBody body = (MappingBody)this.fOperation.getBody();
            if (body != null) {
                boolean nonEmptyMapping;
                boolean isEmptyBody = body.getContent().isEmpty() || body.getContent().size() == 1 && ((OCLExpression)body.getContent().get(0)).getStartPosition() == body.getStartPosition() && ((OCLExpression)body.getContent().get(0)).getEndPosition() == body.getEndPosition();
                boolean bl = nonEmptyMapping = !isEmptyBody || !body.getInitSection().isEmpty() || !body.getEndSection().isEmpty();
                if (nonEmptyMapping) {
                    env.reportWarning(NLS.bind(ValidationMessages.MappingExtension_disjunctingMappingBodyNotExecuted, QvtOperationalParserUtil.safeGetMappingQualifiedName(env, this.fOperation)), body.getStartPosition(), body.getEndPosition());
                }
            }
            result &= this.reportInvalidExtensionsInDisjunctingMapping(env, this.fOperation.getInherited(), MappingExtensionKindCS.INHERITS);
            result &= this.reportInvalidExtensionsInDisjunctingMapping(env, this.fOperation.getMerged(), MappingExtensionKindCS.MERGES);
            return (result &= this.repornInvalidOutParameters(env)) && super.validate(env);
        }

        private boolean repornInvalidOutParameters(QvtOperationalEnv env) {
            boolean result = true;
            int pos = 0;
            for (MappingOperation extended : this.fOperation.getDisjunct()) {
                Iterator itParams = this.fOperation.getEParameters().iterator();
                Iterator itExtendedParams = extended.getEParameters().iterator();
                while (itParams.hasNext()) {
                    MappingParameter mappingParam = (MappingParameter)itParams.next();
                    MappingParameter mappingParamExtended = (MappingParameter)itExtendedParams.next();
                    if (mappingParam.getKind() != DirectionKind.OUT || mappingParamExtended.getType() == mappingParam.getEType()) continue;
                    result = false;
                    ExtensionSourceRefAdapter adapter = this.getSrcAdapter();
                    if (adapter == null) continue;
                    int startOffset = extended.getStartPosition();
                    int endOffset = extended.getEndPosition();
                    MappingSourceReference ref = DisjunctValidator.safeGetSourceRef(adapter.getDisjunctReferences(), pos++);
                    if (ref != null) {
                        startOffset = ref.getStartOffset();
                        endOffset = ref.getEndOffset();
                    }
                    env.reportError(NLS.bind(ValidationMessages.MappingExtension_illegalOutParamDisjunctingMapping, new Object[]{QvtOperationalParserUtil.safeGetMappingQualifiedName(env, this.fOperation), mappingParam.getName(), QvtOperationalParserUtil.safeGetMappingQualifiedName(env, extended)}), startOffset, endOffset);
                }
            }
            return result;
        }

        private boolean reportInvalidExtensionsInDisjunctingMapping(QvtOperationalEnv env, EList<MappingOperation> extendedOperations, MappingExtensionKindCS kind) {
            boolean result = true;
            int pos = 0;
            for (MappingOperation extended : extendedOperations) {
                result = false;
                ExtensionSourceRefAdapter adapter = this.getSrcAdapter();
                if (adapter == null) continue;
                int startOffset = extended.getStartPosition();
                int endOffset = extended.getEndPosition();
                MappingSourceReference ref = null;
                if (kind == MappingExtensionKindCS.INHERITS) {
                    ref = DisjunctValidator.safeGetSourceRef(adapter.getInheritReferences(), pos++);
                } else if (kind == MappingExtensionKindCS.MERGES) {
                    ref = DisjunctValidator.safeGetSourceRef(adapter.getMergeReferences(), pos++);
                }
                if (ref != null) {
                    startOffset = ref.getStartOffset();
                    endOffset = ref.getEndOffset();
                }
                env.reportError(NLS.bind(ValidationMessages.MappingExtension_illegalExtensionKindOnDisjunctingMapping, new Object[]{QvtOperationalParserUtil.safeGetMappingQualifiedName(env, this.fOperation), kind.getName(), QvtOperationalParserUtil.safeGetMappingQualifiedName(env, extended)}), startOffset, endOffset);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionSourceRefAdapter
    extends AdapterImpl {
        List<MappingSourceReference> inheritRefs;
        List<MappingSourceReference> disjunctRefs;
        List<MappingSourceReference> mergeRefs;

        ExtensionSourceRefAdapter() {
        }

        void addDisjunct(MappingOperation mapping, CSTNode sourceRef) {
            if (this.disjunctRefs == null) {
                this.disjunctRefs = new ArrayList<MappingSourceReference>();
            }
            ExtensionSourceRefAdapter.addRef(mapping, sourceRef, this.disjunctRefs);
        }

        void addInherit(MappingOperation mapping, CSTNode sourceRef) {
            if (this.inheritRefs == null) {
                this.inheritRefs = new ArrayList<MappingSourceReference>();
            }
            ExtensionSourceRefAdapter.addRef(mapping, sourceRef, this.inheritRefs);
        }

        void addMerge(MappingOperation mapping, CSTNode sourceRef) {
            if (this.mergeRefs == null) {
                this.mergeRefs = new ArrayList<MappingSourceReference>();
            }
            ExtensionSourceRefAdapter.addRef(mapping, sourceRef, this.mergeRefs);
        }

        public boolean isAdapterForType(Object type) {
            if (type instanceof Class) {
                return ExtensionSourceRefAdapter.class.isAssignableFrom((Class)type);
            }
            return super.isAdapterForType(ExtensionSourceRefAdapter.class);
        }

        static void addRef(MappingOperation mapping, CSTNode sourceRef, List<MappingSourceReference> refList) {
            refList.add(new MappingSourceReference(sourceRef.getStartOffset(), sourceRef.getEndOffset()));
        }

        public List<MappingSourceReference> getInheritReferences() {
            return this.inheritRefs;
        }

        public List<MappingSourceReference> getDisjunctReferences() {
            return this.disjunctRefs;
        }

        public List<MappingSourceReference> getMergeReferences() {
            return this.mergeRefs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ExtensionValidator {
        MappingOperation fOperation;
        List<MappingOperation> fExtendedOpers;
        ExtensionSourceRefAdapter fAdapter;
        boolean shouldUseSourceAdapter;
        MappingExtensionKindCS fExtensionKind;

        ExtensionValidator(MappingOperation operation, List<MappingOperation> extendedOperations, MappingExtensionKindCS extensionKind) {
            this.fOperation = operation;
            this.fExtendedOpers = extendedOperations;
            this.fExtensionKind = extensionKind;
            this.shouldUseSourceAdapter = true;
        }

        ExtensionSourceRefAdapter getSrcAdapter() {
            if (this.fAdapter == null) {
                this.fAdapter = MappingExtensionHelper.getSourceRefAdapter(this.fOperation);
                if (this.getMappingSourceRefs().size() != this.fExtendedOpers.size()) {
                    this.shouldUseSourceAdapter = false;
                }
            }
            return this.shouldUseSourceAdapter ? this.fAdapter : null;
        }

        boolean validate(QvtOperationalEnv env) {
            boolean isValid = true;
            int i = 0;
            while (i < this.fExtendedOpers.size()) {
                MappingOperation extended = this.fExtendedOpers.get(i);
                boolean isNonConformantSignature = !this.isConformantForExtension(this.fOperation, extended, env);
                isValid &= !isNonConformantSignature;
                if (isNonConformantSignature) {
                    MappingSourceReference ref;
                    int startOffset = this.fOperation.getStartPosition();
                    int endOffset = this.fOperation.getEndPosition();
                    ExtensionSourceRefAdapter adapter = this.getSrcAdapter();
                    if (adapter != null && (ref = this.safeGetSourceRef(i)) != null) {
                        startOffset = ref.getStartOffset();
                        endOffset = ref.getEndOffset();
                    }
                    String errMessage = NLS.bind(ValidationMessages.MappingExtension_nonConformantSignatureForMappingExtension, new Object[]{QvtOperationalParserUtil.safeGetMappingQualifiedName(env, extended), this.fExtensionKind, QvtOperationalParserUtil.safeGetMappingQualifiedName(env, this.fOperation)});
                    env.reportError(errMessage, startOffset, endOffset);
                }
                ++i;
            }
            return isValid;
        }

        static MappingSourceReference safeGetSourceRef(List<MappingSourceReference> refList, int pos) {
            return pos >= refList.size() ? null : refList.get(pos);
        }

        MappingSourceReference safeGetSourceRef(int pos) {
            return ExtensionValidator.safeGetSourceRef(this.getMappingSourceRefs(), pos);
        }

        abstract List<MappingSourceReference> getMappingSourceRefs();

        abstract boolean isConformantForExtension(MappingOperation var1, MappingOperation var2, QvtOperationalEnv var3);
    }

    private static class MappingSourceReference {
        private int startOffset;
        private int endOffset;

        private MappingSourceReference(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

