/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.m2m.internal.qvt.oml.ocl.Logger;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibrariesRegistry;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesRegistryImpl
implements LibrariesRegistry {
    private static final String LIBRARY_TAG = "library";
    private final Collection<Library> myLibraries;

    public LibrariesRegistryImpl(IConfigurationElement[] configurations) {
        this.myLibraries = LibrariesRegistryImpl.load(configurations);
    }

    @Override
    public Collection<Library> getLibraries() {
        return Collections.unmodifiableCollection(this.myLibraries);
    }

    @Override
    public Library getLibrary(String id) {
        for (Library lib : this.getLibraries()) {
            if (!lib.getId().equals(id)) continue;
            return lib;
        }
        return null;
    }

    private static Collection<Library> load(IConfigurationElement[] configurations) {
        HashSet registeredLibraryClasses = new HashSet();
        LinkedList<Library> libraries = new LinkedList<Library>();
        int i = 0;
        while (i < configurations.length) {
            if (!LIBRARY_TAG.equals(configurations[i].getName())) {
                Logger.getLogger().log(Logger.WARNING, "Unrecognized tag passed into TransformationConfigurationReader: " + configurations[i].getName());
            } else {
                try {
                    LibraryImpl nextLibrary = new LibraryImpl(configurations[i]);
                    if (!registeredLibraryClasses.contains(nextLibrary.getLibraryClass())) {
                        libraries.add(nextLibrary);
                        registeredLibraryClasses.add(nextLibrary.getLibraryClass());
                    } else {
                        Logger.getLogger().log(Logger.SEVERE, "Same library with the same class was registered twice. Skipping: " + configurations[i].getNamespaceIdentifier());
                    }
                }
                catch (LibraryCreationException e) {
                    Logger.getLogger().log(Logger.SEVERE, "LibraryImpl was not created", e);
                }
            }
            ++i;
        }
        return libraries;
    }
}

