/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.ocl.cst.PathNameCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedModuleCS {
    private final AbstractQVTParser myParser;
    private final CFile mySource;
    private final MappingModuleCS myModuleCS;
    private final Map<PathNameCS, ParsedModuleCS> myResolvedImports;

    public ParsedModuleCS(MappingModuleCS moduleCS, CFile source, AbstractQVTParser parser) {
        if (moduleCS == null || source == null || parser == null) {
            throw new IllegalArgumentException();
        }
        if (!(parser.getEnvironment() instanceof QvtOperationalEnv)) {
            throw new IllegalArgumentException("Parser without environment");
        }
        this.mySource = source;
        this.myModuleCS = moduleCS;
        this.myParser = parser;
        this.myResolvedImports = new LinkedHashMap<PathNameCS, ParsedModuleCS>();
    }

    public CFile getSource() {
        return this.mySource;
    }

    public MappingModuleCS getModuleCS() {
        return this.myModuleCS;
    }

    public QvtOperationalEnv getEnvironment() {
        return (QvtOperationalEnv)this.myParser.getEnvironment();
    }

    public AbstractQVTParser getParser() {
        return this.myParser;
    }

    public Collection<ParsedModuleCS> getParsedImports() {
        return this.myResolvedImports.values();
    }

    public ParsedModuleCS getParsedImport(PathNameCS importPath) {
        return this.myResolvedImports.get(importPath);
    }

    public void addParsedImport(ParsedModuleCS parsedModule, PathNameCS importPath) {
        this.myResolvedImports.put(importPath, parsedModule);
    }

    public String getStringName() {
        if (this.myModuleCS.getHeaderCS() == null || this.myModuleCS.getHeaderCS().getPathNameCS() == null) {
            return null;
        }
        return QvtOperationalParserUtil.getStringRepresentation(this.myModuleCS.getHeaderCS().getPathNameCS(), ".");
    }

    public String toString() {
        return "Parsed module: " + this.mySource.getName();
    }
}

