/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OperationCallExpCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.utilities.ASTNode;

public class OperationHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        SimpleNameCS nameCS;
        EOperation operation;
        CSTNode syntaxElement = context.getSyntaxElement();
        if (syntaxElement instanceof SimpleNameCS && (operation = OperationHyperlinkDetector.resolveOperationDecl(nameCS = (SimpleNameCS)context.getSyntaxElement())) != null) {
            MappingMethodCS methodCS = OperationHyperlinkDetector.resolveMappingOperationDecl(nameCS);
            if (methodCS != null) {
                IRegion destRegion = this.getGoToOperationRegion(methodCS);
                CFile source = ASTBindingHelper.resolveModuleFile((EObject)CSTHelper.getModule((CSTNode)methodCS));
                return new QvtFileHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS), source, destRegion, destRegion);
            }
            return new MetamodelElementHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS), (EModelElement)operation);
        }
        return null;
    }

    public static EOperation resolveOperationDecl(SimpleNameCS nameCS) {
        OperationCallExpCS featureCallExpCS;
        ASTNode featureASTNode;
        if (nameCS.eContainer() instanceof OperationCallExpCS && (featureASTNode = ASTBindingHelper.resolveASTNode((CSTNode)(featureCallExpCS = (OperationCallExpCS)nameCS.eContainer()))) instanceof OperationCallExp) {
            OperationCallExp operationCallExp = (OperationCallExp)featureASTNode;
            return (EOperation)operationCallExp.getReferredOperation();
        }
        return null;
    }

    public static MappingMethodCS resolveMappingOperationDecl(SimpleNameCS nameCS) {
        EOperation operation = OperationHyperlinkDetector.resolveOperationDecl(nameCS);
        if (operation instanceof ImperativeOperation) {
            CSTNode resultCS = ASTBindingHelper.resolveCSTNode((ASTNode)((ImperativeOperation)operation));
            return resultCS instanceof MappingMethodCS ? (MappingMethodCS)resultCS : null;
        }
        return null;
    }

    private IRegion getGoToOperationRegion(MappingMethodCS mappingMethodCS) {
        int startOffset = mappingMethodCS.getStartOffset();
        int length = 0;
        MappingDeclarationCS decl = mappingMethodCS.getMappingDeclarationCS();
        if (decl != null) {
            SimpleNameCS simpleName = decl.getSimpleNameCS();
            length = simpleName != null ? simpleName.getValue().length() : length;
            TypeCS context = decl.getContextType();
            if (context != null) {
                startOffset = mappingMethodCS.getMappingDeclarationCS().getContextType().getEndOffset();
                startOffset += 3;
            } else {
                startOffset = simpleName.getStartOffset();
            }
        }
        return new Region(startOffset, length);
    }
}

